/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CustomFormatterResourceDefinition;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggingSubsystemParser_4_0;
import org.jboss.as.logging.PatternFormatterResourceDefinition;
import org.jboss.as.logging.formatters.StructuredFormatterResourceDefinition;
import org.jboss.as.logging.formatters.XmlFormatterResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class LoggingSubsystemParser_5_0
extends LoggingSubsystemParser_4_0 {
    LoggingSubsystemParser_5_0() {
    }

    @Override
    void parseFormatter(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block10: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PATTERN_FORMATTER: {
                    ModelNode operation = Util.createAddOperation();
                    LoggingSubsystemParser_5_0.addOperationAddress(operation, address, PatternFormatterResourceDefinition.PATTERN_FORMATTER.getName(), name);
                    this.parsePatternFormatterElement(reader, operation);
                    operations.add(operation);
                    continue block10;
                }
                case CUSTOM_FORMATTER: {
                    ModelNode operation = Util.createAddOperation();
                    LoggingSubsystemParser_5_0.addOperationAddress(operation, address, CustomFormatterResourceDefinition.CUSTOM_FORMATTER.getName(), name);
                    this.parseCustomFormatterElement(reader, operation);
                    operations.add(operation);
                    continue block10;
                }
                case JSON_FORMATTER: {
                    ModelNode operation = Util.createAddOperation();
                    LoggingSubsystemParser_5_0.addOperationAddress(operation, address, "json-formatter", name);
                    this.parseStructuredFormatter(reader, operation, new SimpleAttributeDefinition[0]);
                    operations.add(operation);
                    continue block10;
                }
                case XML_FORMATTER: {
                    ModelNode operation = Util.createAddOperation();
                    LoggingSubsystemParser_5_0.addOperationAddress(operation, address, "xml-formatter", name);
                    this.parseStructuredFormatter(reader, operation, XmlFormatterResourceDefinition.NAMESPACE_URI, XmlFormatterResourceDefinition.PRINT_NAMESPACE);
                    operations.add(operation);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseStructuredFormatter(XMLExtendedStreamReader reader, ModelNode operation, SimpleAttributeDefinition ... additionalAttributes) throws XMLStreamException {
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attributeName = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if (attributeName.equals(StructuredFormatterResourceDefinition.DATE_FORMAT.getXmlName())) {
                StructuredFormatterResourceDefinition.DATE_FORMAT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                continue;
            }
            if (attributeName.equals(StructuredFormatterResourceDefinition.PRETTY_PRINT.getXmlName())) {
                StructuredFormatterResourceDefinition.PRETTY_PRINT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                continue;
            }
            if (attributeName.equals(StructuredFormatterResourceDefinition.PRINT_DETAILS.getXmlName())) {
                StructuredFormatterResourceDefinition.PRINT_DETAILS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                continue;
            }
            if (attributeName.equals(StructuredFormatterResourceDefinition.ZONE_ID.getXmlName())) {
                StructuredFormatterResourceDefinition.ZONE_ID.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                continue;
            }
            boolean invalid = true;
            for (SimpleAttributeDefinition ad : additionalAttributes) {
                if (!attributeName.equals(ad.getXmlName())) continue;
                invalid = false;
                ad.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                break;
            }
            if (!invalid) continue;
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
        }
        HashSet<String> encountered = new HashSet<String>();
        while (reader.nextTag() != 2) {
            String elementName = reader.getLocalName();
            if (!encountered.add(elementName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (elementName.equals(StructuredFormatterResourceDefinition.EXCEPTION_OUTPUT_TYPE.getXmlName())) {
                StructuredFormatterResourceDefinition.EXCEPTION_OUTPUT_TYPE.parseAndSetParameter(LoggingSubsystemParser_5_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                continue;
            }
            if (elementName.equals(StructuredFormatterResourceDefinition.RECORD_DELIMITER.getXmlName())) {
                StructuredFormatterResourceDefinition.RECORD_DELIMITER.parseAndSetParameter(LoggingSubsystemParser_5_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                continue;
            }
            if (elementName.equals(StructuredFormatterResourceDefinition.KEY_OVERRIDES.getXmlName())) {
                StructuredFormatterResourceDefinition.KEY_OVERRIDES.getParser().parseElement((AttributeDefinition)StructuredFormatterResourceDefinition.KEY_OVERRIDES, reader, operation);
                continue;
            }
            if (elementName.equals(StructuredFormatterResourceDefinition.META_DATA.getXmlName())) {
                LoggingSubsystemParser_5_0.parsePropertyElement(operation, reader, StructuredFormatterResourceDefinition.META_DATA.getName());
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

