/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.remoting;

import java.security.Permission;
import javax.net.ssl.SSLSession;
import org.jboss.as.security.remoting.RemoteConnection;
import org.jboss.as.security.remoting.RemotingPermission;
import org.jboss.remoting3.Connection;
import org.wildfly.security.auth.server.SecurityIdentity;

public class RemotingContext {
    private static final RemotingPermission CLEAR_CONNECTION = new RemotingPermission("clearConnection");
    private static final RemotingPermission GET_CONNECTION = new RemotingPermission("getConnection");
    private static final RemotingPermission IS_CONNECTION_SET = new RemotingPermission("isConnectionSet");
    private static final RemotingPermission SET_CONNECTION = new RemotingPermission("setConnection");
    private static ThreadLocal<RemoteConnection> connection = new ThreadLocal();

    public static void setConnection(Connection connection) {
        RemotingContext.checkPermission(SET_CONNECTION);
        RemotingContext.connection.set(new RemotingRemoteConnection(connection));
    }

    public static void setConnection(RemoteConnection connection) {
        RemotingContext.checkPermission(SET_CONNECTION);
        RemotingContext.connection.set(connection);
    }

    public static void clear() {
        RemotingContext.checkPermission(CLEAR_CONNECTION);
        connection.set(null);
    }

    public static Connection getConnection() {
        RemotingContext.checkPermission(GET_CONNECTION);
        RemoteConnection remoteConnection = connection.get();
        if (remoteConnection instanceof RemotingRemoteConnection) {
            return ((RemotingRemoteConnection)remoteConnection).connection;
        }
        return null;
    }

    public static RemoteConnection getRemoteConnection() {
        RemotingContext.checkPermission(GET_CONNECTION);
        return connection.get();
    }

    public static boolean isSet() {
        RemotingContext.checkPermission(IS_CONNECTION_SET);
        return connection.get() != null;
    }

    private static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }

    private static final class RemotingRemoteConnection
    implements RemoteConnection {
        final Connection connection;

        private RemotingRemoteConnection(Connection connection) {
            this.connection = connection;
        }

        @Override
        public SSLSession getSslSession() {
            return this.connection.getSslSession();
        }

        @Override
        public SecurityIdentity getSecurityIdentity() {
            return this.connection.getLocalIdentity();
        }
    }
}

