/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;

public final class ElytronSubsystemTransformers
implements ExtensionTransformerRegistration {
    private static final ModelVersion ELYTRON_1_2_0 = ModelVersion.create((int)1, (int)2);
    private static final ModelVersion ELYTRON_2_0_0 = ModelVersion.create((int)2, (int)0);
    private static final ModelVersion ELYTRON_3_0_0 = ModelVersion.create((int)3, (int)0);
    private static final AttributeConverter MAPPING_PERMISSION_SET_CONVERTER = new AttributeConverter.DefaultAttributeConverter(){

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                for (ModelNode permissionMapping : attributeValue.asList()) {
                    if (!permissionMapping.hasDefined("permission-sets")) continue;
                    ModelNode permissionSets = permissionMapping.get("permission-sets");
                    for (ModelNode permissionSet : permissionSets.asList()) {
                        ModelNode permissionSetName = permissionSet.get("permission-set");
                        PathAddress permissionSetAddress = address.getParent().append("permission-set", permissionSetName.asString());
                        ModelNode permissions = context.readResourceFromRoot(permissionSetAddress).getModel().get("permissions");
                        for (ModelNode permission : permissions.asList()) {
                            permissionMapping.get("permissions").add(permission);
                        }
                    }
                    permissionMapping.remove("permission-sets");
                }
            }
        }
    };
    private static final AttributeConverter CONSTANT_PERMISSION_SET_CONVERTER = new AttributeConverter.DefaultAttributeConverter(){

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                ModelNode allPermissions = new ModelNode();
                for (ModelNode permissionSet : attributeValue.asList()) {
                    ModelNode permissionSetName = permissionSet.get("permission-set");
                    PathAddress permissionSetAddress = address.getParent().append("permission-set", permissionSetName.asString());
                    ModelNode permissions = context.readResourceFromRoot(permissionSetAddress).getModel().get("permissions");
                    for (ModelNode permission : permissions.asList()) {
                        allPermissions.add(permission);
                    }
                }
                attributeValue.set(allPermissions);
            }
        }
    };

    public String getSubsystemName() {
        return "elytron";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getCurrentSubsystemVersion());
        ResourceTransformationDescriptionBuilder builderCurrentTo2_0_0 = chainedBuilder.createBuilder(ELYTRON_3_0_0, ELYTRON_2_0_0);
        builderCurrentTo2_0_0.discardChildResource(PathElement.pathElement((String)"permission-set"));
        ((AttributeTransformationDescriptionBuilder)builderCurrentTo2_0_0.addChildResource(PathElement.pathElement((String)"simple-permission-mapper")).getAttributeBuilder().setValueConverter(MAPPING_PERMISSION_SET_CONVERTER, new String[]{"permission-mappings"})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builderCurrentTo2_0_0.addChildResource(PathElement.pathElement((String)"constant-permission-mapper")).getAttributeBuilder().addRename("permission-sets", "permissions")).setValueConverter(CONSTANT_PERMISSION_SET_CONVERTER, new String[]{"permission-sets"})).end();
        chainedBuilder.createBuilder(ELYTRON_2_0_0, ELYTRON_1_2_0);
        chainedBuilder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{ELYTRON_2_0_0, ELYTRON_1_2_0}});
    }
}

