/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Set;
import java.util.function.Function;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public interface CapabilityReferenceRecorder {
    public void addCapabilityRequirements(OperationContext var1, Resource var2, String var3, String ... var4);

    public void removeCapabilityRequirements(OperationContext var1, Resource var2, String var3, String ... var4);

    @Deprecated
    public String getBaseDependentName();

    public String getBaseRequirementName();

    @Deprecated
    default public boolean isDynamicDependent() {
        throw new UnsupportedOperationException();
    }

    default public String[] getRequirementPatternSegments(String name, PathAddress address) {
        if (name != null && !name.isEmpty()) {
            return new String[]{name};
        }
        return new String[0];
    }

    public static class ResourceCapabilityReferenceRecorder
    implements CapabilityReferenceRecorder {
        private final Function<PathAddress, String[]> dynamicDependentNameMapper;
        private final Function<PathAddress, String[]> dynamicRequirementNameMapper;
        private final String baseRequirementName;
        private final String baseDependentName;

        public ResourceCapabilityReferenceRecorder(Function<PathAddress, String[]> dynamicDependentNameMapper, String baseDependentName, Function<PathAddress, String[]> dynamicRequirementNameMapper, String baseRequirementName) {
            this.dynamicDependentNameMapper = dynamicDependentNameMapper;
            this.dynamicRequirementNameMapper = dynamicRequirementNameMapper;
            this.baseRequirementName = baseRequirementName;
            this.baseDependentName = baseDependentName;
        }

        public ResourceCapabilityReferenceRecorder(String baseDependentName, Function<PathAddress, String[]> dynamicRequirementNameMapper, String baseRequirementName) {
            this(null, baseDependentName, dynamicRequirementNameMapper, baseRequirementName);
        }

        @Override
        public void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, attributeName, false);
        }

        @Override
        public void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, attributeName, true);
        }

        private void processCapabilityRequirement(OperationContext context, String attributeName, boolean remove) {
            String dependentName = this.getDependentName(context.getCurrentAddress());
            String requirementName = this.getRequirementName(context.getCurrentAddress());
            if (remove) {
                context.deregisterCapabilityRequirement(requirementName, dependentName);
            } else {
                context.registerAdditionalCapabilityRequirement(requirementName, dependentName, attributeName);
            }
        }

        private String getDependentName(PathAddress address) {
            if (this.dynamicDependentNameMapper != null) {
                return RuntimeCapability.buildDynamicCapabilityName(this.baseDependentName, this.dynamicDependentNameMapper.apply(address));
            }
            return this.baseDependentName;
        }

        private String getRequirementName(PathAddress address) {
            if (this.dynamicRequirementNameMapper != null) {
                return RuntimeCapability.buildDynamicCapabilityName(this.baseRequirementName, this.dynamicRequirementNameMapper.apply(address));
            }
            return this.baseRequirementName;
        }

        @Override
        public String getBaseDependentName() {
            return this.baseDependentName;
        }

        @Override
        public String getBaseRequirementName() {
            return this.baseRequirementName;
        }

        @Override
        public boolean isDynamicDependent() {
            return this.dynamicDependentNameMapper != null;
        }

        @Override
        public String[] getRequirementPatternSegments(String dynamicElement, PathAddress registrationAddress) {
            String[] dynamicElements = registrationAddress != null && this.dynamicRequirementNameMapper != null ? this.dynamicRequirementNameMapper.apply(registrationAddress) : new String[]{};
            if (dynamicElement != null && !dynamicElement.isEmpty()) {
                String[] result = new String[dynamicElements.length + 1];
                for (int i = 0; i < dynamicElements.length; ++i) {
                    result[i] = dynamicElements[i].charAt(0) == '$' ? dynamicElements[i].substring(1) : dynamicElements[i];
                }
                result[dynamicElements.length] = dynamicElement;
                return result;
            }
            return dynamicElements;
        }
    }

    public static class CompositeAttributeDependencyRecorder
    extends ContextDependencyRecorder {
        private AttributeDefinition[] attributes;
        private RuntimeCapability capability;

        CompositeAttributeDependencyRecorder(String baseRequirementName, AttributeDefinition ... attributes) {
            super(baseRequirementName);
            this.attributes = attributes;
            this.capability = null;
        }

        CompositeAttributeDependencyRecorder(RuntimeCapability capability, String baseRequirementName, AttributeDefinition ... attributes) {
            super(baseRequirementName);
            this.attributes = attributes;
            this.capability = capability;
        }

        @Override
        protected RuntimeCapability getDependentCapability(OperationContext context) {
            if (this.capability != null) {
                return this.capability;
            }
            return super.getDependentCapability(context);
        }

        @Override
        protected String getRequirementName(OperationContext context, Resource resource, String attributeValue) {
            ModelNode model = resource.getModel();
            String[] dynamicParts = new String[this.attributes.length + 1];
            try {
                for (int i = 0; i < this.attributes.length; ++i) {
                    AttributeDefinition ad = this.attributes[i];
                    dynamicParts[i] = ad.resolveModelAttribute(context, model).asString();
                }
            }
            catch (OperationFailedException e) {
                throw new RuntimeException(e);
            }
            dynamicParts[this.attributes.length] = attributeValue;
            return RuntimeCapability.buildDynamicCapabilityName(this.baseRequirementName, dynamicParts);
        }

        @Override
        public String[] getRequirementPatternSegments(String dynamicElement, PathAddress address) {
            ArrayList<String> dynamicParts = new ArrayList<String>();
            for (int i = 0; i < this.attributes.length; ++i) {
                dynamicParts.add(this.attributes[i].getName());
            }
            if (dynamicElement != null && !dynamicElement.isEmpty()) {
                String element = dynamicElement;
                dynamicParts.add(element);
            }
            return dynamicParts.toArray(new String[dynamicParts.size()]);
        }
    }

    public static class ContextDependencyRecorder
    implements CapabilityReferenceRecorder {
        final String baseRequirementName;

        ContextDependencyRecorder(String baseRequirementName) {
            this.baseRequirementName = baseRequirementName;
        }

        @Override
        public final void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, resource, attributeName, false, attributeValues);
        }

        @Override
        public final void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, resource, attributeName, true, attributeValues);
        }

        void processCapabilityRequirement(OperationContext context, Resource resource, String attributeName, boolean remove, String ... attributeValues) {
            RuntimeCapability cap = this.getDependentCapability(context);
            String dependentName = this.getDependentName(cap, context);
            for (String attributeValue : attributeValues) {
                if (attributeValue == null) continue;
                String requirementName = this.getRequirementName(context, resource, attributeValue);
                if (remove) {
                    context.deregisterCapabilityRequirement(requirementName, dependentName);
                    continue;
                }
                context.registerAdditionalCapabilityRequirement(requirementName, dependentName, attributeName);
            }
        }

        protected RuntimeCapability getDependentCapability(OperationContext context) {
            ImmutableManagementResourceRegistration mrr = context.getResourceRegistration();
            Set<RuntimeCapability> capabilities = mrr.getCapabilities();
            assert (capabilities != null && capabilities.size() == 1);
            return capabilities.iterator().next();
        }

        String getDependentName(RuntimeCapability cap, OperationContext context) {
            if (cap.isDynamicallyNamed()) {
                return cap.fromBaseCapability(context.getCurrentAddress()).getName();
            }
            return cap.getName();
        }

        protected String getRequirementName(OperationContext context, Resource resource, String attributeValue) {
            return RuntimeCapability.buildDynamicCapabilityName(this.baseRequirementName, attributeValue);
        }

        @Override
        public String getBaseDependentName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBaseRequirementName() {
            return this.baseRequirementName;
        }
    }

    public static class DefaultCapabilityReferenceRecorder
    implements CapabilityReferenceRecorder {
        private final String baseRequirementName;
        private final String baseDependentName;
        private final boolean dynamicDependent;

        DefaultCapabilityReferenceRecorder(String baseRequirementName, String baseDependentName, boolean dynamicDependent) {
            this.baseRequirementName = baseRequirementName;
            this.baseDependentName = baseDependentName;
            this.dynamicDependent = dynamicDependent;
        }

        @Override
        public final void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, attributeName, false, attributeValues);
        }

        @Override
        public final void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, attributeName, true, attributeValues);
        }

        private void processCapabilityRequirement(OperationContext context, String attributeName, boolean remove, String ... attributeValues) {
            String dependentName = this.dynamicDependent ? RuntimeCapability.buildDynamicCapabilityName(this.baseDependentName, this.getDynamicDependentName(context.getCurrentAddress())) : this.baseDependentName;
            for (String attributeValue : attributeValues) {
                if (attributeValue == null) continue;
                String requirementName = RuntimeCapability.buildDynamicCapabilityName(this.baseRequirementName, attributeValue);
                if (remove) {
                    context.deregisterCapabilityRequirement(requirementName, dependentName);
                    continue;
                }
                context.registerAdditionalCapabilityRequirement(requirementName, dependentName, attributeName);
            }
        }

        String getDynamicDependentName(PathAddress currentAddress) {
            return currentAddress.getLastElement().getValue();
        }

        @Override
        public String getBaseDependentName() {
            return this.baseDependentName;
        }

        @Override
        public String getBaseRequirementName() {
            return this.baseRequirementName;
        }
    }
}

