/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.predicate.Predicate;
import io.undertow.server.HttpHandler;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.FilterLocation;
import org.wildfly.extension.undertow.UndertowFilter;
import org.wildfly.extension.undertow.filters.FilterService;

public class FilterRef
implements Service<FilterRef>,
UndertowFilter {
    private final Predicate predicate;
    private final int priority;
    private final InjectedValue<FilterService> filter = new InjectedValue();
    private final InjectedValue<FilterLocation> location = new InjectedValue();

    public FilterRef(Predicate predicate, int priority) {
        this.predicate = predicate;
        this.priority = priority;
    }

    public void start(StartContext context) throws StartException {
        ((FilterLocation)this.location.getValue()).addFilter(this);
    }

    public void stop(StopContext context) {
        ((FilterLocation)this.location.getValue()).removeFilter(this);
    }

    InjectedValue<FilterService> getFilter() {
        return this.filter;
    }

    InjectedValue<FilterLocation> getLocation() {
        return this.location;
    }

    public HttpHandler createHttpHandler(HttpHandler next) {
        return ((FilterService)this.filter.getValue()).createHttpHandler(this.predicate, next);
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public FilterRef getValue() throws IllegalStateException {
        return this;
    }

    public HttpHandler wrap(HttpHandler handler) {
        return ((FilterService)this.filter.getValue()).createHttpHandler(this.predicate, handler);
    }
}

