/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.auth;

import java.io.IOException;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.aesh.cmd.security.HttpServerCommandActivator;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.auth.AbstractEnableAuthenticationCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthFactorySpec;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.jboss.as.cli.impl.aesh.cmd.security.model.HTTPServer;
import org.jboss.as.cli.operation.OperationFormatException;

@CommandDefinition(name="enable-http-auth-http-server", description="", activator=HttpServerCommandActivator.class)
public class HTTPServerEnableAuthCommand
extends AbstractEnableAuthenticationCommand {
    @Option(name="security-domain", required=true, completer=SecurityCommand.OptionCompleters.SecurityDomainCompleter.class)
    String securityDomain;

    public HTTPServerEnableAuthCommand() {
        super(AuthFactorySpec.HTTP);
    }

    @Override
    protected void secure(CommandContext ctx, AuthSecurityBuilder builder) throws Exception {
        if (this.getEnabledFactory(ctx) == null) {
            HTTPServer.enableHTTPAuthentication(builder, this.securityDomain, ctx);
        }
    }

    @Override
    protected String getEnabledFactory(CommandContext ctx) throws IOException, OperationFormatException {
        return HTTPServer.getSecurityDomainFactoryName(this.securityDomain, ctx);
    }

    @Override
    protected String getOOTBFactory(CommandContext ctx) throws Exception {
        return ElytronUtil.OOTB_APPLICATION_HTTP_FACTORY;
    }

    @Override
    protected String getSecuredEndpoint(CommandContext ctx) {
        return "security domain " + this.securityDomain;
    }
}

