/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StabilityMonitor;

public class ServiceSupplier<T>
implements Supplier<T> {
    private final ServiceRegistry registry;
    private final ServiceName name;
    private final ServiceController.Mode mode;
    private volatile Duration duration = null;

    ServiceSupplier(ServiceRegistry registry, ServiceName name, ServiceController.Mode mode) {
        this.registry = registry;
        this.name = name;
        this.mode = mode;
    }

    public ServiceSupplier<T> setTimeout(Duration duration) {
        this.duration = duration;
        return this;
    }

    @Override
    public T get() {
        ServiceContainer target = this.registry.getRequiredService(this.name).getServiceContainer();
        ServiceName name = this.name.append(new String[]{UUID.randomUUID().toString()});
        ServiceBuilder builder = target.addService(name);
        Supplier supplier = builder.requires(this.name);
        ServiceController controller = builder.setInitialMode(this.mode).install();
        StabilityMonitor monitor = new StabilityMonitor();
        monitor.addController(controller);
        try {
            Duration duration = this.duration;
            if (duration == null) {
                monitor.awaitStability();
            } else if (!monitor.awaitStability(duration.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException(new TimeoutException());
            }
            switch (controller.getState()) {
                case START_FAILED: {
                    throw new IllegalStateException((Throwable)controller.getStartException());
                }
                case UP: {
                    Object t = supplier.get();
                    return t;
                }
            }
            T t = null;
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        finally {
            monitor.removeController(controller);
            controller.setMode(ServiceController.Mode.REMOVE);
        }
    }
}

