/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert.acme;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLReason;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.security.auth.x500.X500Principal;
import org.wildfly.common.Assert;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.Version;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.asn1.ASN1Encodable;
import org.wildfly.security.asn1.DERDecoder;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.X500;
import org.wildfly.security.x500.X500AttributeTypeAndValue;
import org.wildfly.security.x500.X500PrincipalBuilder;
import org.wildfly.security.x500.cert.PKCS10CertificateSigningRequest;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;
import org.wildfly.security.x500.cert.SubjectAlternativeNamesExtension;
import org.wildfly.security.x500.cert.X509CertificateChainAndSigningKey;
import org.wildfly.security.x500.cert.acme.Acme;
import org.wildfly.security.x500.cert.acme.AcmeAccount;
import org.wildfly.security.x500.cert.acme.AcmeChallenge;
import org.wildfly.security.x500.cert.acme.AcmeException;
import org.wildfly.security.x500.cert.acme.AcmeMetadata;
import org.wildfly.security.x500.cert.acme.AcmeResource;
import org.wildfly.security.x500.cert.util.KeyUtil;

public abstract class AcmeClientSpi {
    public static final int DEFAULT_EC_KEY_SIZE = 256;
    public static final int DEFAULT_KEY_SIZE = 2048;
    public static final String DEFAULT_KEY_ALGORITHM_NAME = "RSA";
    private static final int MAX_RETRIES = 10;
    private static final long DEFAULT_RETRY_AFTER_MILLI = 3000L;
    private static final int[] CONTENT_TYPE_DELIMS = new int[]{59, 61};
    private static final String CHARSET = "charset";
    private static final String UTF_8 = "utf-8";
    private static final String USER_AGENT_STRING = "Elytron ACME Client/" + Version.getVersion();
    private static final JsonObject EMPTY_PAYLOAD = Json.createObjectBuilder().build();

    public Map<AcmeResource, URL> getResourceUrls(AcmeAccount account, boolean staging) throws AcmeException {
        Assert.checkNotNullParam((String)"account", (Object)account);
        Map<AcmeResource, URL> resourceUrls = account.getResourceUrls(staging);
        if (resourceUrls.isEmpty()) {
            HttpURLConnection connection = this.sendGetRequest(account.getServerUrl(staging), 200, "application/json");
            JsonObject directoryJson = AcmeClientSpi.getJsonResponse(connection);
            try {
                for (AcmeResource resource : AcmeResource.values()) {
                    String resourceUrl = AcmeClientSpi.getOptionalJsonString(directoryJson, resource.getValue());
                    URL url = resourceUrl != null ? new URL(resourceUrl) : null;
                    resourceUrls.put(resource, url);
                }
            }
            catch (MalformedURLException e) {
                throw ElytronMessages.acme.unableToRetrieveAcmeServerDirectoryUrls(e);
            }
        }
        return resourceUrls;
    }

    public AcmeMetadata getMetadata(AcmeAccount account, boolean staging) throws AcmeException {
        JsonArray caaIdentitiesArray;
        String websiteUrl;
        Assert.checkNotNullParam((String)"account", (Object)account);
        HttpURLConnection connection = this.sendGetRequest(account.getServerUrl(staging), 200, "application/json");
        JsonObject directoryJson = AcmeClientSpi.getJsonResponse(connection);
        JsonObject metadata = directoryJson.getJsonObject("meta");
        if (metadata == null) {
            return null;
        }
        AcmeMetadata.Builder metadataBuilder = AcmeMetadata.builder();
        String termsOfServiceUrl = AcmeClientSpi.getOptionalJsonString(metadata, "termsOfService");
        if (termsOfServiceUrl != null) {
            metadataBuilder.setTermsOfServiceUrl(termsOfServiceUrl);
        }
        if ((websiteUrl = AcmeClientSpi.getOptionalJsonString(metadata, "website")) != null) {
            metadataBuilder.setWebsiteUrl(websiteUrl);
        }
        if ((caaIdentitiesArray = metadata.getJsonArray("caaIdentities")) != null) {
            ArrayList<String> caaIdentities = new ArrayList<String>(caaIdentitiesArray.size());
            for (JsonString caaIdentity : caaIdentitiesArray.getValuesAs(JsonString.class)) {
                caaIdentities.add(caaIdentity.getString());
            }
            metadataBuilder.setCaaIdentities(caaIdentities.toArray(new String[caaIdentities.size()]));
        }
        boolean externalAccountRequired = metadata.getBoolean("externalAccountRequired", false);
        metadataBuilder.setExternalAccountRequired(externalAccountRequired);
        return metadataBuilder.build();
    }

    public boolean createAccount(AcmeAccount account, boolean staging) throws AcmeException {
        return this.createAccount(account, staging, false);
    }

    public boolean createAccount(AcmeAccount account, boolean staging, boolean onlyReturnExisting) throws AcmeException {
        Assert.checkNotNullParam((String)"account", (Object)account);
        String newAccountUrl = this.getResourceUrl(account, AcmeResource.NEW_ACCOUNT, staging).toString();
        JsonObjectBuilder payloadBuilder = Json.createObjectBuilder();
        if (onlyReturnExisting) {
            payloadBuilder.add("onlyReturnExisting", true);
        } else {
            payloadBuilder.add("termsOfServiceAgreed", account.isTermsOfServiceAgreed());
            if (account.getContactUrls() != null && account.getContactUrls().length != 0) {
                JsonArrayBuilder contactBuilder = Json.createArrayBuilder();
                for (String contactUrl : account.getContactUrls()) {
                    contactBuilder.add(contactUrl);
                }
                payloadBuilder.add("contact", (JsonValue)contactBuilder.build());
            }
        }
        HttpURLConnection connection = this.sendPostRequestWithRetries(account, staging, newAccountUrl, true, AcmeClientSpi.getEncodedJson(payloadBuilder.build()), 201, 200);
        account.setAccountUrl(AcmeClientSpi.getLocation(connection));
        try {
            return connection.getResponseCode() == 201;
        }
        catch (IOException e) {
            throw new AcmeException(e);
        }
    }

    public void updateAccount(AcmeAccount account, boolean staging, boolean termsOfServiceAgreed) throws AcmeException {
        this.updateAccount(account, staging, termsOfServiceAgreed, null);
    }

    public void updateAccount(AcmeAccount account, boolean staging, String[] contactUrls) throws AcmeException {
        this.updateAccount(account, staging, account.isTermsOfServiceAgreed(), contactUrls);
    }

    public void updateAccount(AcmeAccount account, boolean staging, boolean termsOfServiceAgreed, String[] contactUrls) throws AcmeException {
        Assert.checkNotNullParam((String)"account", (Object)account);
        JsonObjectBuilder payloadBuilder = Json.createObjectBuilder().add("termsOfServiceAgreed", termsOfServiceAgreed);
        if (contactUrls != null && contactUrls.length != 0) {
            JsonArrayBuilder contactBuilder = Json.createArrayBuilder();
            for (String contactUrl : contactUrls) {
                contactBuilder.add(contactUrl);
            }
            payloadBuilder.add("contact", (JsonValue)contactBuilder.build());
        }
        this.sendPostRequestWithRetries(account, staging, this.getAccountUrl(account, staging), false, AcmeClientSpi.getEncodedJson(payloadBuilder.build()), 200);
        account.setTermsOfServiceAgreed(termsOfServiceAgreed);
        if (contactUrls != null && contactUrls.length != 0) {
            account.setContactUrls(contactUrls);
        }
    }

    public void changeAccountKey(AcmeAccount account, boolean staging) throws AcmeException {
        Assert.checkNotNullParam((String)"account", (Object)account);
        SelfSignedX509CertificateAndSigningKey newCertificateAndSigningKey = SelfSignedX509CertificateAndSigningKey.builder().setKeySize(account.getKeySize()).setKeyAlgorithmName(account.getKeyAlgorithmName()).setDn(account.getDn()).build();
        this.changeAccountKey(account, staging, newCertificateAndSigningKey.getSelfSignedCertificate(), newCertificateAndSigningKey.getSigningKey());
    }

    public void changeAccountKey(AcmeAccount account, boolean staging, X509Certificate certificate, PrivateKey privateKey) throws AcmeException {
        Assert.checkNotNullParam((String)"account", (Object)account);
        Assert.checkNotNullParam((String)"certificate", (Object)certificate);
        Assert.checkNotNullParam((String)"privateKey", (Object)privateKey);
        String keyChangeUrl = this.getResourceUrl(account, AcmeResource.KEY_CHANGE, staging).toString();
        String signatureAlgorithm = KeyUtil.getDefaultCompatibleSignatureAlgorithmName(privateKey);
        String algHeader = Acme.getAlgHeaderFromSignatureAlgorithm(signatureAlgorithm);
        String innerEncodedProtectedHeader = AcmeClientSpi.getEncodedProtectedHeader(algHeader, certificate.getPublicKey(), keyChangeUrl);
        JsonObjectBuilder innerPayloadBuilder = Json.createObjectBuilder().add("account", this.getAccountUrl(account, staging)).add("newKey", (JsonValue)Acme.getJwk(certificate.getPublicKey(), algHeader));
        String innerEncodedPayload = AcmeClientSpi.getEncodedJson(innerPayloadBuilder.build());
        String innerEncodedSignature = AcmeClientSpi.getEncodedSignature(privateKey, signatureAlgorithm, innerEncodedProtectedHeader, innerEncodedPayload);
        String outerEncodedPayload = AcmeClientSpi.getEncodedJson(AcmeClientSpi.getJws(innerEncodedProtectedHeader, innerEncodedPayload, innerEncodedSignature));
        this.sendPostRequestWithRetries(account, staging, keyChangeUrl, false, outerEncodedPayload, 200);
        account.changeCertificateAndPrivateKey(certificate, privateKey);
    }

    public void deactivateAccount(AcmeAccount account, boolean staging) throws AcmeException {
        Assert.checkNotNullParam((String)"account", (Object)account);
        JsonObject payload = Json.createObjectBuilder().add("status", "deactivated").build();
        this.sendPostRequestWithRetries(account, staging, this.getAccountUrl(account, staging), false, AcmeClientSpi.getEncodedJson(payload), 200);
    }

    public X509CertificateChainAndSigningKey obtainCertificateChain(AcmeAccount account, boolean staging, String ... domainNames) throws AcmeException {
        return this.obtainCertificateChain(account, staging, null, -1, domainNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CertificateChainAndSigningKey obtainCertificateChain(AcmeAccount account, boolean staging, String keyAlgorithmName, int keySize, String ... domainNames) throws AcmeException {
        Assert.checkNotNullParam((String)"account", (Object)account);
        Assert.checkNotNullParam((String)"domainNames", (Object)domainNames);
        LinkedHashSet<String> domainNamesSet = AcmeClientSpi.getDomainNames(domainNames);
        String newOrderUrl = this.getResourceUrl(account, AcmeResource.NEW_ORDER, staging).toString();
        JsonArrayBuilder identifiersBuilder = Json.createArrayBuilder();
        for (String domainName : domainNamesSet) {
            JsonObject identifier = Json.createObjectBuilder().add("type", "dns").add("value", domainName).build();
            identifiersBuilder.add((JsonValue)identifier);
        }
        JsonObjectBuilder payloadBuilder = Json.createObjectBuilder().add("identifiers", (JsonValue)identifiersBuilder.build());
        HttpURLConnection connection = this.sendPostRequestWithRetries(account, staging, newOrderUrl, false, AcmeClientSpi.getEncodedJson(payloadBuilder.build()), 201);
        JsonObject jsonResponse = AcmeClientSpi.getJsonResponse(connection);
        String finalizeOrderUrl = jsonResponse.getString("finalize");
        JsonArray authorizationsArray = jsonResponse.getJsonArray("authorizations");
        ArrayList<String> authorizationUrls = new ArrayList<String>(authorizationsArray.size());
        for (Object authorization : authorizationsArray.getValuesAs(JsonString.class)) {
            authorizationUrls.add(authorization.getString());
        }
        ArrayList<AcmeChallenge> selectedChallenges = new ArrayList<AcmeChallenge>(authorizationUrls.size());
        try {
            for (String string : authorizationUrls) {
                connection = this.sendGetRequest(string, 200, "application/json");
                jsonResponse = AcmeClientSpi.getJsonResponse(connection);
                AcmeChallenge selectedChallenge = this.respondToChallenges(account, staging, jsonResponse);
                if (selectedChallenge == null) continue;
                selectedChallenges.add(selectedChallenge);
            }
            for (String string : authorizationUrls) {
                jsonResponse = this.pollResourceUntilFinalized(string);
                if (jsonResponse.getString("status").equals("valid")) continue;
                throw ElytronMessages.acme.challengeResponseFailedValidationByAcmeServer();
            }
            ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>(domainNamesSet.size());
            for (String domainName : domainNamesSet) {
                generalNames.add(new GeneralName.DNSName(domainName));
            }
            X500PrincipalBuilder x500PrincipalBuilder = new X500PrincipalBuilder();
            x500PrincipalBuilder.addItem(X500AttributeTypeAndValue.create("2.5.4.3", ASN1Encodable.ofUtf8String(((GeneralName.DNSName)generalNames.get(0)).getName())));
            X500Principal dn = x500PrincipalBuilder.build();
            if (keyAlgorithmName == null) {
                keyAlgorithmName = DEFAULT_KEY_ALGORITHM_NAME;
            }
            if (keySize == -1) {
                keySize = keyAlgorithmName.equals("EC") ? 256 : 2048;
            }
            SelfSignedX509CertificateAndSigningKey selfSignedX509CertificateAndSigningKey = SelfSignedX509CertificateAndSigningKey.builder().setDn(dn).setKeyAlgorithmName(keyAlgorithmName).setKeySize(keySize).build();
            PKCS10CertificateSigningRequest.Builder csrBuilder = PKCS10CertificateSigningRequest.builder().setCertificate(selfSignedX509CertificateAndSigningKey.getSelfSignedCertificate()).setSigningKey(selfSignedX509CertificateAndSigningKey.getSigningKey()).setSubjectDn(dn);
            csrBuilder.addExtension(new SubjectAlternativeNamesExtension(false, generalNames));
            payloadBuilder = Json.createObjectBuilder().add("csr", Acme.base64UrlEncode(csrBuilder.build().getEncoded()));
            connection = this.sendPostRequestWithRetries(account, staging, finalizeOrderUrl, false, AcmeClientSpi.getEncodedJson(payloadBuilder.build()), 200);
            String orderUrl = AcmeClientSpi.getLocation(connection);
            jsonResponse = this.pollResourceUntilFinalized(orderUrl);
            if (!jsonResponse.getString("status").equals("valid")) {
                throw ElytronMessages.acme.noCertificateWillBeIssuedByAcmeServer();
            }
            String certificateUrl = AcmeClientSpi.getOptionalJsonString(jsonResponse, "certificate");
            if (certificateUrl == null) {
                throw ElytronMessages.acme.noCertificateUrlProvidedByAcmeServer();
            }
            connection = this.sendGetRequest(certificateUrl, 200, "application/pem-certificate-chain");
            X509Certificate[] certificateChain = AcmeClientSpi.getPemCertificateChain(connection);
            PrivateKey privateKey = selfSignedX509CertificateAndSigningKey.getSigningKey();
            X509CertificateChainAndSigningKey x509CertificateChainAndSigningKey = new X509CertificateChainAndSigningKey(certificateChain, privateKey);
            return x509CertificateChainAndSigningKey;
        }
        finally {
            for (AcmeChallenge challenge : selectedChallenges) {
                this.cleanupAfterChallenge(account, challenge);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createAuthorization(AcmeAccount account, boolean staging, String domainName) throws AcmeException {
        Assert.checkNotNullParam((String)"account", (Object)account);
        Assert.checkNotNullParam((String)"domainName", (Object)domainName);
        String newAuthzUrl = this.getResourceUrl(account, AcmeResource.NEW_AUTHZ, staging).toString();
        JsonObject identifier = Json.createObjectBuilder().add("type", "dns").add("value", AcmeClientSpi.getSanitizedDomainName(domainName)).build();
        JsonObjectBuilder payloadBuilder = Json.createObjectBuilder().add("identifier", (JsonValue)identifier);
        HttpURLConnection connection = this.sendPostRequestWithRetries(account, staging, newAuthzUrl, false, AcmeClientSpi.getEncodedJson(payloadBuilder.build()), 201);
        String authorizationUrl = AcmeClientSpi.getLocation(connection);
        JsonObject jsonResponse = AcmeClientSpi.getJsonResponse(connection);
        AcmeChallenge selectedChallenge = this.respondToChallenges(account, staging, jsonResponse);
        try {
            jsonResponse = this.pollResourceUntilFinalized(authorizationUrl);
            if (!jsonResponse.getString("status").equals("valid")) {
                throw ElytronMessages.acme.challengeResponseFailedValidationByAcmeServer();
            }
            String string = authorizationUrl;
            return string;
        }
        finally {
            if (selectedChallenge != null) {
                this.cleanupAfterChallenge(account, selectedChallenge);
            }
        }
    }

    public void deactivateAuthorization(AcmeAccount account, boolean staging, String authorizationUrl) throws AcmeException {
        Assert.checkNotNullParam((String)"account", (Object)account);
        Assert.checkNotNullParam((String)"authorizationUrl", (Object)authorizationUrl);
        JsonObject payload = Json.createObjectBuilder().add("status", "deactivated").build();
        this.sendPostRequestWithRetries(account, staging, authorizationUrl, false, AcmeClientSpi.getEncodedJson(payload), 200);
    }

    public abstract AcmeChallenge proveIdentifierControl(AcmeAccount var1, List<AcmeChallenge> var2) throws AcmeException;

    public abstract void cleanupAfterChallenge(AcmeAccount var1, AcmeChallenge var2) throws AcmeException;

    public void revokeCertificate(AcmeAccount account, boolean staging, X509Certificate certificate) throws AcmeException {
        this.revokeCertificate(account, staging, certificate, null);
    }

    public void revokeCertificate(AcmeAccount account, boolean staging, X509Certificate certificate, CRLReason reason) throws AcmeException {
        byte[] encodedCertificate;
        Assert.checkNotNullParam((String)"account", (Object)account);
        Assert.checkNotNullParam((String)"certificate", (Object)certificate);
        String revokeCertUrl = this.getResourceUrl(account, AcmeResource.REVOKE_CERT, staging).toString();
        try {
            encodedCertificate = certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw ElytronMessages.acme.unableToGetEncodedFormOfCertificateToBeRevoked(e);
        }
        JsonObjectBuilder payloadBuilder = Json.createObjectBuilder().add("certificate", Acme.base64UrlEncode(encodedCertificate));
        if (reason != null) {
            payloadBuilder.add("reason", reason.ordinal());
        }
        this.sendPostRequestWithRetries(account, staging, revokeCertUrl, false, AcmeClientSpi.getEncodedJson(payloadBuilder.build()), 200);
    }

    public byte[] getNewNonce(AcmeAccount account, boolean staging) throws AcmeException {
        Assert.checkNotNullParam((String)"account", (Object)account);
        try {
            byte[] nonce;
            URL newNonceUrl = this.getResourceUrl(account, AcmeResource.NEW_NONCE, staging);
            HttpURLConnection connection = (HttpURLConnection)newNonceUrl.openConnection();
            connection.setRequestMethod("HEAD");
            connection.setRequestProperty("Accept-Language", Locale.getDefault().toLanguageTag());
            connection.setRequestProperty("User-Agent", USER_AGENT_STRING);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode != 204 && responseCode != 200) {
                AcmeClientSpi.handleAcmeErrorResponse(connection, responseCode);
            }
            if ((nonce = AcmeClientSpi.getReplayNonce(connection)) == null) {
                throw ElytronMessages.acme.noNonceProvidedByAcmeServer();
            }
            return nonce;
        }
        catch (Exception e) {
            throw ElytronMessages.acme.unableToObtainNewNonceFromAcmeServer();
        }
    }

    String[] queryAccountContactUrls(AcmeAccount account, boolean staging) throws AcmeException {
        Assert.checkNotNullParam((String)"account", (Object)account);
        HttpURLConnection connection = this.sendPostRequestWithRetries(account, staging, this.getAccountUrl(account, staging), false, AcmeClientSpi.getEncodedJson(EMPTY_PAYLOAD), 200);
        JsonObject jsonResponse = AcmeClientSpi.getJsonResponse(connection);
        JsonArray contactsArray = jsonResponse.getJsonArray("contact");
        if (contactsArray != null && contactsArray.size() > 0) {
            ArrayList<String> contacts = new ArrayList<String>(contactsArray.size());
            for (JsonString contact : contactsArray.getValuesAs(JsonString.class)) {
                contacts.add(contact.getString());
            }
            return contacts.toArray(new String[contacts.size()]);
        }
        return null;
    }

    String queryAccountStatus(AcmeAccount account, boolean staging) throws AcmeException {
        Assert.checkNotNullParam((String)"account", (Object)account);
        HttpURLConnection connection = this.sendPostRequestWithRetries(account, staging, this.getAccountUrl(account, staging), false, AcmeClientSpi.getEncodedJson(EMPTY_PAYLOAD), 200);
        JsonObject jsonResponse = AcmeClientSpi.getJsonResponse(connection);
        return jsonResponse.getString("status");
    }

    private URL getResourceUrl(AcmeAccount account, AcmeResource resource, boolean staging) throws AcmeException {
        URL resourceUrl = this.getResourceUrls(account, staging).get((Object)resource);
        if (resourceUrl == null) {
            throw ElytronMessages.acme.resourceNotSupportedByAcmeServer(resource.getValue());
        }
        return resourceUrl;
    }

    private HttpURLConnection sendGetRequest(String resourceUrl, int expectedResponseCode, String expectedContentType) throws AcmeException {
        try {
            URL directoryUrl = new URL(resourceUrl);
            HttpURLConnection connection = (HttpURLConnection)directoryUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept-Language", Locale.getDefault().toLanguageTag());
            connection.setRequestProperty("User-Agent", USER_AGENT_STRING);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode != expectedResponseCode) {
                AcmeClientSpi.handleAcmeErrorResponse(connection, responseCode);
            }
            String contentType = connection.getContentType();
            if (!AcmeClientSpi.checkContentType(connection, expectedContentType)) {
                throw ElytronMessages.acme.unexpectedContentTypeFromAcmeServer(contentType);
            }
            return connection;
        }
        catch (Exception e) {
            if (e instanceof AcmeException) {
                throw (AcmeException)e;
            }
            throw new AcmeException(e);
        }
    }

    private HttpURLConnection sendPostRequestWithRetries(AcmeAccount account, boolean staging, String resourceUrl, boolean useJwk, String encodedPayload, int ... expectedResponseCodes) throws AcmeException {
        try {
            URL url = new URL(resourceUrl);
            for (int i = 0; i < 10; ++i) {
                String encodedProtectedHeader = this.getEncodedProtectedHeader(useJwk, resourceUrl, account, staging);
                String encodedSignature = AcmeClientSpi.getEncodedSignature(account.getPrivateKey(), account.getSignature(), encodedProtectedHeader, encodedPayload);
                JsonObject jws = AcmeClientSpi.getJws(encodedProtectedHeader, encodedPayload, encodedSignature);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/jose+json");
                connection.setRequestProperty("Accept-Language", Locale.getDefault().toLanguageTag());
                connection.setRequestProperty("User-Agent", USER_AGENT_STRING);
                connection.setDoOutput(true);
                connection.setFixedLengthStreamingMode(jws.toString().length());
                connection.connect();
                OutputStream out = connection.getOutputStream();
                Object object = null;
                try {
                    out.write(jws.toString().getBytes(StandardCharsets.US_ASCII));
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (out != null) {
                        if (object != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
                int responseCode = connection.getResponseCode();
                account.setNonce(AcmeClientSpi.getReplayNonce(connection));
                for (Object expectedResponseCode : (Object)expectedResponseCodes) {
                    if (expectedResponseCode != responseCode) continue;
                    return connection;
                }
                AcmeClientSpi.handleAcmeErrorResponse(connection, responseCode);
            }
            throw ElytronMessages.acme.badAcmeNonce();
        }
        catch (Exception e) {
            if (e instanceof AcmeException) {
                throw (AcmeException)e;
            }
            throw new AcmeException(e);
        }
    }

    private JsonObject pollResourceUntilFinalized(String resourceUrl) throws AcmeException {
        JsonObject jsonResponse;
        boolean statusFinalized;
        do {
            statusFinalized = true;
            HttpURLConnection connection = this.sendGetRequest(resourceUrl, 200, "application/json");
            jsonResponse = AcmeClientSpi.getJsonResponse(connection);
            String status = jsonResponse.getString("status");
            if (status.equals("valid") || status.equals("invalid")) continue;
            statusFinalized = false;
            long retryAfterMilli = AcmeClientSpi.getRetryAfter(connection, true);
            if (retryAfterMilli <= 0L) continue;
            try {
                Thread.sleep(retryAfterMilli);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        } while (!statusFinalized);
        return jsonResponse;
    }

    private AcmeChallenge respondToChallenges(AcmeAccount account, boolean staging, JsonObject authorization) throws AcmeException {
        ArrayList<AcmeChallenge> challenges = null;
        if (authorization.getString("status").equals("pending")) {
            JsonObject identifier = authorization.getJsonObject("identifier");
            JsonArray challengeArray = authorization.getJsonArray("challenges");
            challenges = new ArrayList<AcmeChallenge>(challengeArray.size());
            for (JsonObject challenge : challengeArray.getValuesAs(JsonObject.class)) {
                challenges.add(new AcmeChallenge(AcmeChallenge.Type.forName(challenge.getString("type")), challenge.getString("url"), challenge.getString("token"), identifier.getString("type"), identifier.getString("value")));
            }
        }
        if (challenges != null && !challenges.isEmpty()) {
            AcmeChallenge selectedChallenge = this.proveIdentifierControl(account, (List<AcmeChallenge>)challenges);
            try {
                this.sendPostRequestWithRetries(account, staging, selectedChallenge.getUrl(), false, AcmeClientSpi.getEncodedJson(EMPTY_PAYLOAD), 200);
                return selectedChallenge;
            }
            catch (AcmeException e) {
                this.cleanupAfterChallenge(account, selectedChallenge);
                throw e;
            }
        }
        return null;
    }

    private static LinkedHashSet<String> getDomainNames(String[] domainNames) throws AcmeException {
        if (domainNames.length == 0) {
            throw ElytronMessages.acme.domainNamesIsEmpty();
        }
        LinkedHashSet<String> domainNamesSet = new LinkedHashSet<String>();
        for (String domainName : domainNames) {
            domainNamesSet.add(AcmeClientSpi.getSanitizedDomainName(domainName));
        }
        return domainNamesSet;
    }

    private static String getSanitizedDomainName(String domainName) throws AcmeException {
        if (domainName == null) {
            throw ElytronMessages.acme.domainNameIsNull();
        }
        domainName = IDN.toASCII(domainName.trim());
        return domainName.toLowerCase(Locale.ROOT);
    }

    private static JsonObject getJsonResponse(HttpURLConnection connection) throws AcmeException {
        JsonObject jsonResponse;
        try (BufferedInputStream inputStream = new BufferedInputStream(connection.getResponseCode() < 400 ? connection.getInputStream() : connection.getErrorStream());){
            jsonResponse = Json.createReader((InputStream)inputStream).readObject();
        }
        catch (IOException e) {
            throw ElytronMessages.acme.unableToObtainJsonResponseFromAcmeServer(e);
        }
        return jsonResponse;
    }

    private static byte[] getReplayNonce(HttpURLConnection connection) throws AcmeException {
        String nonce = connection.getHeaderField("Replay-Nonce");
        if (nonce == null) {
            return null;
        }
        return CodePointIterator.ofString((String)nonce).base64Decode(Acme.BASE64_URL, false).drain();
    }

    private static String getLocation(HttpURLConnection connection) throws AcmeException {
        String location = connection.getHeaderField("Location");
        if (location == null) {
            throw ElytronMessages.acme.noAccountLocationUrlProvidedByAcmeServer();
        }
        return location;
    }

    private static long getRetryAfter(HttpURLConnection connection, boolean useDefaultIfHeaderNotPresent) throws AcmeException {
        long retryAfterMilli;
        block4: {
            retryAfterMilli = -1L;
            String retryAfter = connection.getHeaderField("Retry-After");
            if (retryAfter != null) {
                try {
                    retryAfterMilli = Integer.parseInt(retryAfter) * 1000;
                }
                catch (NumberFormatException e) {
                    long retryAfterDate = connection.getHeaderFieldDate("Retry-After", 0L);
                    if (retryAfterDate == 0L) break block4;
                    retryAfterMilli = retryAfterDate - Instant.now().toEpochMilli();
                }
            }
        }
        if (retryAfterMilli == -1L && useDefaultIfHeaderNotPresent) {
            retryAfterMilli = 3000L;
        }
        return retryAfterMilli;
    }

    private static void handleAcmeErrorResponse(HttpURLConnection connection, int responseCode) throws AcmeException {
        try {
            String problemMessages;
            String responseMessage = connection.getResponseMessage();
            if (!AcmeClientSpi.checkContentType(connection, "application/problem+json")) {
                throw ElytronMessages.acme.unexpectedResponseCodeFromAcmeServer(responseCode, responseMessage);
            }
            JsonObject jsonResponse = AcmeClientSpi.getJsonResponse(connection);
            String type = AcmeClientSpi.getOptionalJsonString(jsonResponse, "type");
            if (type != null) {
                if (type.equals("urn:ietf:params:acme:error:badNonce")) {
                    return;
                }
                if (type.equals("urn:ietf:params:acme:error:userActionRequired")) {
                    String instance = AcmeClientSpi.getOptionalJsonString(jsonResponse, "instance");
                    if (instance != null) {
                        throw ElytronMessages.acme.userActionRequired(instance);
                    }
                } else if (type.equals("urn:ietf:params:acme:error:rateLimited")) {
                    long retryAfter = AcmeClientSpi.getRetryAfter(connection, false);
                    if (retryAfter > 0L) {
                        throw ElytronMessages.acme.rateLimitExceededTryAgainLater(Instant.ofEpochMilli(retryAfter));
                    }
                    throw ElytronMessages.acme.rateLimitExceeded();
                }
            }
            if ((problemMessages = AcmeClientSpi.getProblemMessages(jsonResponse)) != null && !problemMessages.isEmpty()) {
                throw new AcmeException(problemMessages);
            }
            throw ElytronMessages.acme.unexpectedResponseCodeFromAcmeServer(responseCode, responseMessage);
        }
        catch (Exception e) {
            if (e instanceof AcmeException) {
                throw (AcmeException)e;
            }
            throw new AcmeException(e);
        }
    }

    private static String getProblemMessages(JsonObject errorResponse) {
        JsonArray subproblems;
        StringBuilder problemMessages = new StringBuilder();
        String mainProblem = AcmeClientSpi.getProblemMessage(errorResponse);
        if (mainProblem != null) {
            problemMessages.append(AcmeClientSpi.getProblemMessage(errorResponse));
        }
        if ((subproblems = errorResponse.getJsonArray("subproblems")) != null && subproblems.size() > 0) {
            problemMessages.append(":");
            for (JsonObject subproblem : subproblems.getValuesAs(JsonObject.class)) {
                problemMessages.append("\n").append(AcmeClientSpi.getProblemMessage(subproblem));
            }
        }
        return problemMessages.toString();
    }

    private static String getProblemMessage(JsonObject jsonResponse) {
        String type = AcmeClientSpi.getOptionalJsonString(jsonResponse, "type");
        String detail = AcmeClientSpi.getOptionalJsonString(jsonResponse, "detail");
        String title = AcmeClientSpi.getOptionalJsonString(jsonResponse, "title");
        String problemMessage = null;
        if (detail != null) {
            problemMessage = detail;
        } else if (title != null) {
            problemMessage = title;
        } else if (type != null) {
            problemMessage = type;
        }
        return problemMessage;
    }

    private static String getOptionalJsonString(JsonObject jsonObject, String name) {
        JsonString value = jsonObject.getJsonString(name);
        if (value == null) {
            return null;
        }
        return value.getString();
    }

    private static X509Certificate[] getPemCertificateChain(HttpURLConnection connection) throws AcmeException {
        try {
            Collection<? extends Certificate> reply;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            try (BufferedInputStream inputStream = new BufferedInputStream(AcmeClientSpi.getConvertedInputStream(connection.getInputStream()));){
                reply = certificateFactory.generateCertificates(inputStream);
            }
            return X500.asX509CertificateArray(reply.toArray(new Certificate[reply.size()]));
        }
        catch (IOException | CertificateException e) {
            throw ElytronMessages.acme.unableToDownloadCertificateChainFromAcmeServer(e);
        }
    }

    private static String getEncodedJson(JsonObject jsonObject) {
        return CodePointIterator.ofString((String)jsonObject.toString()).asUtf8().base64Encode(Acme.BASE64_URL, false).drainToString();
    }

    private static JsonObject getJws(String encodedProtectedHeader, String encodedPayload, String encodedSignature) {
        return Json.createObjectBuilder().add("protected", encodedProtectedHeader).add("payload", encodedPayload).add("signature", encodedSignature).build();
    }

    private static String getEncodedProtectedHeader(String algHeader, PublicKey publicKey, String resourceUrl) {
        JsonObject protectedHeader = Json.createObjectBuilder().add("alg", algHeader).add("jwk", (JsonValue)Acme.getJwk(publicKey, algHeader)).add("url", resourceUrl).build();
        return AcmeClientSpi.getEncodedJson(protectedHeader);
    }

    private String getEncodedProtectedHeader(boolean useJwk, String resourceUrl, AcmeAccount account, boolean staging) throws AcmeException {
        JsonObjectBuilder protectedHeaderBuilder = Json.createObjectBuilder().add("alg", account.getAlgHeader());
        if (useJwk) {
            protectedHeaderBuilder.add("jwk", (JsonValue)Acme.getJwk(account.getPublicKey(), account.getAlgHeader()));
        } else {
            protectedHeaderBuilder.add("kid", this.getAccountUrl(account, staging));
        }
        protectedHeaderBuilder.add("nonce", Acme.base64UrlEncode(this.getNonce(account, staging))).add("url", resourceUrl);
        return AcmeClientSpi.getEncodedJson(protectedHeaderBuilder.build());
    }

    private static String getEncodedSignature(PrivateKey privateKey, Signature signature, String encodedProtectedHeader, String encodedPayload) throws AcmeException {
        try {
            signature.update((encodedProtectedHeader + "." + encodedPayload).getBytes(StandardCharsets.UTF_8));
            byte[] signatureBytes = signature.sign();
            if (privateKey instanceof ECPrivateKey) {
                int rActual;
                DERDecoder derDecoder = new DERDecoder(signatureBytes);
                derDecoder.startSequence();
                byte[] r = derDecoder.drainElementValue();
                byte[] s = derDecoder.drainElementValue();
                derDecoder.endSequence();
                int rLength = r.length;
                int sLength = s.length;
                int sActual = sLength;
                for (rActual = rLength; rActual > 0 && r[rLength - rActual] == 0; --rActual) {
                }
                while (sActual > 0 && s[sLength - sActual] == 0) {
                    --sActual;
                }
                int rawLength = Math.max(rActual, sActual);
                int signatureByteLength = AcmeClientSpi.getECSignatureByteLength(signature.getAlgorithm());
                rawLength = Math.max(rawLength, signatureByteLength / 2);
                byte[] concatenatedSignatureBytes = new byte[rawLength * 2];
                System.arraycopy(r, rLength - rActual, concatenatedSignatureBytes, rawLength - rActual, rActual);
                System.arraycopy(s, sLength - sActual, concatenatedSignatureBytes, 2 * rawLength - sActual, sActual);
                return Acme.base64UrlEncode(concatenatedSignatureBytes);
            }
            return Acme.base64UrlEncode(signatureBytes);
        }
        catch (SignatureException e) {
            throw ElytronMessages.acme.unableToCreateAcmeSignature(e);
        }
    }

    private static String getEncodedSignature(PrivateKey privateKey, String signatureAlgorithm, String encodedProtectedHeader, String encodedPayload) throws AcmeException {
        try {
            Signature signature = Signature.getInstance(signatureAlgorithm);
            signature.initSign(privateKey);
            return AcmeClientSpi.getEncodedSignature(privateKey, signature, encodedProtectedHeader, encodedPayload);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw ElytronMessages.acme.unableToCreateAcmeSignature(e);
        }
    }

    private static int getECSignatureByteLength(String signatureAlgorithm) throws AcmeException {
        switch (signatureAlgorithm) {
            case "SHA256withECDSA": {
                return 64;
            }
            case "SHA384withECDSA": {
                return 96;
            }
            case "SHA512withECDSA": {
                return 132;
            }
        }
        throw ElytronMessages.acme.unsupportedAcmeAccountSignatureAlgorithm(signatureAlgorithm);
    }

    private byte[] getNonce(AcmeAccount account, boolean staging) throws AcmeException {
        byte[] nonce = account.getNonce();
        if (nonce == null) {
            nonce = this.getNewNonce(account, staging);
        }
        return nonce;
    }

    private String getAccountUrl(AcmeAccount account, boolean staging) throws AcmeException {
        String accountUrl = account.getAccountUrl();
        if (accountUrl == null) {
            this.createAccount(account, staging, true);
            accountUrl = account.getAccountUrl();
            if (accountUrl == null) {
                ElytronMessages.acme.acmeAccountDoesNotExist();
            }
        }
        return accountUrl;
    }

    private static boolean checkContentType(HttpURLConnection connection, String expectedMediaType) throws AcmeException {
        String contentType = connection.getContentType();
        CodePointIterator cpi = CodePointIterator.ofString((String)contentType);
        CodePointIterator di = cpi.delimitedBy(CONTENT_TYPE_DELIMS);
        String mediaType = di.drainToString().trim();
        AcmeClientSpi.skipDelims(di, cpi, CONTENT_TYPE_DELIMS);
        while (di.hasNext()) {
            String value;
            String parameter = di.drainToString().trim();
            AcmeClientSpi.skipDelims(di, cpi, CONTENT_TYPE_DELIMS);
            if (!parameter.equalsIgnoreCase(CHARSET) || (value = di.drainToString().trim()).equalsIgnoreCase(UTF_8)) continue;
            return false;
        }
        return mediaType.equalsIgnoreCase(expectedMediaType);
    }

    private static void skipDelims(CodePointIterator di, CodePointIterator cpi, int ... delims) throws AcmeException {
        while (!di.hasNext() && cpi.hasNext()) {
            if (AcmeClientSpi.isDelim(cpi.next(), delims)) continue;
            throw ElytronMessages.acme.invalidContentTypeFromAcmeServer();
        }
    }

    private static boolean isDelim(int c, int ... delims) {
        for (int delim : delims) {
            if (delim != c) continue;
            return true;
        }
        return false;
    }

    private static InputStream getConvertedInputStream(InputStream inputStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                if (currentLine.trim().isEmpty()) continue;
                sb.append(currentLine + System.lineSeparator());
            }
        }
        return new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8));
    }
}

