/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert.acme;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.json.JsonObject;
import org.wildfly.common.Assert;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.x500.cert.acme.Acme;
import org.wildfly.security.x500.cert.acme.AcmeAccount;
import org.wildfly.security.x500.cert.acme.AcmeException;

public final class AcmeChallenge {
    private final Type type;
    private final String url;
    private final String token;
    private final String identifierType;
    private final String identifierValue;

    public AcmeChallenge(Type type, String url, String token, String identifierType, String identifierValue) {
        Assert.checkNotNullParam("type", type);
        Assert.checkNotNullParam("url", url);
        Assert.checkNotNullParam("token", token);
        Assert.checkNotNullParam("identifierType", identifierType);
        Assert.checkNotNullParam("identifierValue", identifierValue);
        this.type = type;
        this.url = url;
        this.token = token;
        this.identifierType = identifierType;
        this.identifierValue = identifierValue;
    }

    public Type getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getToken() {
        return this.token;
    }

    public String getIdentifierType() {
        return this.identifierType;
    }

    public String getIdentifierValue() {
        return this.identifierValue;
    }

    public String getKeyAuthorization(AcmeAccount account) throws AcmeException {
        Assert.checkNotNullParam("account", account);
        JsonObject jwk = Acme.getJwk(account.getPublicKey(), account.getAlgHeader());
        byte[] jwkWithoutWhitespace = CodePointIterator.ofString(jwk.toString()).skip(Character::isWhitespace).skipCrLf().asUtf8().drain();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(jwkWithoutWhitespace);
            byte[] jwkThumbprint = messageDigest.digest();
            return this.token + "." + Acme.base64UrlEncode(jwkThumbprint);
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.acme.unableToDetermineKeyAuthorizationString(e);
        }
    }

    public static enum Type {
        HTTP_01("http-01"),
        DNS_01("dns-01"),
        TLS_SNI_01("tls-sni-01"),
        TLS_SNI_02("tls-sni-02");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        static Type forName(String name) {
            switch (name) {
                case "http-01": {
                    return HTTP_01;
                }
                case "dns-01": {
                    return DNS_01;
                }
                case "tls-sni-01": {
                    return TLS_SNI_01;
                }
                case "tls-sni-02": {
                    return TLS_SNI_02;
                }
            }
            return null;
        }
    }
}

