/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.tool;

import java.io.File;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.tool.ContentPolicyBuilderImpl;
import org.jboss.as.patching.tool.PatchOperationTarget;
import org.jboss.as.patching.tool.PatchTool;
import org.jboss.dmr.ModelNode;

public interface PatchOperationBuilder
extends PatchTool.ContentPolicyBuilder {
    public ModelNode execute(PatchOperationTarget var1) throws PatchingException;

    public static abstract class AbstractOperationBuilder
    extends ContentPolicyBuilderImpl
    implements PatchOperationBuilder {
    }

    public static class Factory {
        private Factory() {
        }

        public static PatchOperationBuilder streams() {
            return new AbstractOperationBuilder(){

                @Override
                public ModelNode execute(PatchOperationTarget target) throws PatchingException {
                    return target.streams();
                }
            };
        }

        public static PatchOperationBuilder info() {
            return Factory.info(null);
        }

        public static PatchOperationBuilder info(final String patchStream) {
            return new AbstractOperationBuilder(){

                @Override
                public ModelNode execute(PatchOperationTarget target) throws PatchingException {
                    return target.info(patchStream);
                }
            };
        }

        public static PatchOperationBuilder info(String patchId, boolean verbose) {
            return Factory.info(null, patchId, verbose);
        }

        public static PatchOperationBuilder info(final String patchStream, final String patchId, final boolean verbose) {
            return new AbstractOperationBuilder(){

                @Override
                public ModelNode execute(PatchOperationTarget target) throws PatchingException {
                    return target.info(patchStream, patchId, verbose);
                }
            };
        }

        public static PatchOperationBuilder history() {
            return Factory.history(null);
        }

        public static PatchOperationBuilder history(String patchStream) {
            return Factory.history(patchStream, false);
        }

        public static PatchOperationBuilder history(final String patchStream, final boolean excludeAgedOut) {
            return new AbstractOperationBuilder(){

                @Override
                public ModelNode execute(PatchOperationTarget target) throws PatchingException {
                    return target.history(patchStream, excludeAgedOut);
                }
            };
        }

        public static PatchOperationBuilder rollback(String patchId, boolean rollbackTo, boolean resetConfiguration) {
            return Factory.rollback(null, patchId, rollbackTo, resetConfiguration);
        }

        public static PatchOperationBuilder rollback(final String patchStream, final String patchId, final boolean rollbackTo, final boolean resetConfiguration) {
            return new AbstractOperationBuilder(){

                @Override
                public ModelNode execute(PatchOperationTarget target) throws PatchingException {
                    return target.rollback(patchStream, patchId, this, rollbackTo, resetConfiguration);
                }
            };
        }

        public static PatchOperationBuilder rollbackLast(boolean resetConfiguration) {
            return Factory.rollbackLast(null, resetConfiguration);
        }

        public static PatchOperationBuilder rollbackLast(final String patchStream, final boolean resetConfiguration) {
            return new AbstractOperationBuilder(){

                @Override
                public ModelNode execute(PatchOperationTarget target) throws PatchingException {
                    return target.rollbackLast(patchStream, this, resetConfiguration);
                }
            };
        }

        public static PatchOperationBuilder patch(final File file) {
            return new AbstractOperationBuilder(){

                @Override
                public ModelNode execute(PatchOperationTarget target) throws PatchingException {
                    return target.applyPatch(file, this);
                }
            };
        }
    }
}

