/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Enumeration;
import org.jboss.vfs.VirtualFilePermission;

final class VirtualFilePermissionCollection
extends PermissionCollection {
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("list", VirtualFilePermission[].class)};
    private static final VirtualFilePermission[] NO_PERMISSIONS = new VirtualFilePermission[0];
    private volatile VirtualFilePermission[] permissions = NO_PERMISSIONS;
    private static final Field listField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            Field field;
            try {
                field = VirtualFilePermissionCollection.class.getDeclaredField("permissions");
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
            field.setAccessible(true);
            return field;
        }
    });

    VirtualFilePermissionCollection() {
    }

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof VirtualFilePermission)) {
            throw new IllegalArgumentException();
        }
        this.add((VirtualFilePermission)permission);
    }

    public synchronized void add(VirtualFilePermission permission) {
        if (permission == null) {
            throw new IllegalArgumentException();
        }
        VirtualFilePermission[] permissions = this.permissions;
        int length = permissions.length;
        VirtualFilePermission[] newPermissions = Arrays.copyOf(permissions, length + 1);
        newPermissions[length] = permission;
        this.permissions = newPermissions;
    }

    @Override
    public boolean implies(Permission permission) {
        return permission instanceof VirtualFilePermission && this.implies((VirtualFilePermission)permission);
    }

    private boolean implies(VirtualFilePermission permission) {
        assert (permission != null);
        int remainingFlags = permission.getActionFlags();
        if (remainingFlags == 0) {
            return true;
        }
        VirtualFilePermission[] permissions = this.permissions;
        String theirName = permission.getName();
        for (VirtualFilePermission ourPermission : permissions) {
            if (!VirtualFilePermission.impliesPath(ourPermission.getName(), theirName) || (remainingFlags &= ~ourPermission.getActionFlags()) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Enumeration<Permission> elements() {
        final VirtualFilePermission[] permissions = this.permissions;
        return new Enumeration<Permission>(){
            private int idx = 0;

            @Override
            public boolean hasMoreElements() {
                return this.idx < permissions.length;
            }

            @Override
            public Permission nextElement() {
                return permissions[this.idx++];
            }
        };
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        try {
            listField.set(this, ois.readFields().get("list", null));
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }
}

