/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io.logging;

import java.net.InetSocketAddress;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.wildfly.common.net.CidrAddress;

@MessageLogger(projectCode="WFLYIO", length=3)
public interface IOLogger
extends BasicLogger {
    public static final IOLogger ROOT_LOGGER = (IOLogger)Logger.getMessageLogger(IOLogger.class, (String)"org.wildfly.extension.io");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Worker '%s' has auto-configured to %d core threads with %d task threads based on your %d available processors")
    public void printDefaults(String var1, int var2, int var3, int var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Worker '%s' has auto-configured to %d core threads based on your %d available processors")
    public void printDefaultsIoThreads(String var1, int var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Worker '%s' has auto-configured to %d task threads based on your %d available processors")
    public void printDefaultsWorkerThreads(String var1, int var2, int var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="Worker '%s' would auto-configure to %d task threads based on %d available processors, however your system does not have enough file descriptors configured to support this configuration. It is likely you will experience application degradation unless you increase your file descriptor limit.")
    public void lowFD(String var1, int var2, int var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="Your system is configured with %d file descriptors, but your current application server configuration will require a minimum of %d (and probably more than that); attempting to adjust, however you should expect stability problems unless you increase this number")
    public void lowGlobalFD(int var1, int var2);

    @Message(id=6, value="no metrics available")
    public String noMetrics();

    @Message(id=7, value="Unexpected bind address conflict in resource \"%s\" when attempting to establish binding for destination %s to %s: a binding of %s already existed")
    public OperationFailedException unexpectedBindAddressConflict(PathAddress var1, CidrAddress var2, InetSocketAddress var3, InetSocketAddress var4);
}

