/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.server.deployment.scanner.DeploymentScannerDefinition;
import org.jboss.as.server.deployment.scanner.DeploymentScannerService;
import org.jboss.as.server.deployment.scanner.FileSystemDeploymentService;
import org.jboss.as.server.deployment.scanner.api.DeploymentOperations;
import org.jboss.as.server.deployment.scanner.logging.DeploymentScannerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.JBossThreadFactory;

class DeploymentScannerAdd
implements OperationStepHandler {
    private final PathManager pathManager;

    public DeploymentScannerAdd(PathManager pathManager) {
        this.pathManager = pathManager;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        final ModelNode model = resource.getModel();
        for (SimpleAttributeDefinition atr : DeploymentScannerDefinition.ALL_ATTRIBUTES) {
            atr.validateAndSet(operation, model);
        }
        this.recordCapabilitiesAndRequirements(context, resource, (AttributeDefinition[])DeploymentScannerDefinition.ALL_ATTRIBUTES);
        boolean stepCompleted = false;
        if (context.isNormalServer()) {
            FileSystemDeploymentService bootTimeScanner;
            boolean enabled = DeploymentScannerDefinition.SCAN_ENABLED.resolveModelAttribute(context, operation).asBoolean();
            boolean bootTimeScan = context.isBooting() && enabled;
            String path = DeploymentScannerDefinition.PATH.resolveModelAttribute(context, operation).asString();
            ModelNode relativeToNode = DeploymentScannerDefinition.RELATIVE_TO.resolveModelAttribute(context, operation);
            String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
            boolean autoDeployZip = DeploymentScannerDefinition.AUTO_DEPLOY_ZIPPED.resolveModelAttribute(context, operation).asBoolean();
            boolean autoDeployExp = DeploymentScannerDefinition.AUTO_DEPLOY_EXPLODED.resolveModelAttribute(context, operation).asBoolean();
            boolean autoDeployXml = DeploymentScannerDefinition.AUTO_DEPLOY_XML.resolveModelAttribute(context, operation).asBoolean();
            long deploymentTimeout = DeploymentScannerDefinition.DEPLOYMENT_TIMEOUT.resolveModelAttribute(context, operation).asLong();
            int scanInterval = DeploymentScannerDefinition.SCAN_INTERVAL.resolveModelAttribute(context, operation).asInt();
            boolean rollback = DeploymentScannerDefinition.RUNTIME_FAILURE_CAUSES_ROLLBACK.resolveModelAttribute(context, operation).asBoolean();
            final ScheduledExecutorService scheduledExecutorService = DeploymentScannerAdd.createScannerExecutorService();
            if (bootTimeScan) {
                String pathName = this.pathManager.resolveRelativePathEntry(path, relativeTo);
                File relativePath = null;
                if (relativeTo != null) {
                    relativePath = new File(this.pathManager.getPathEntry(relativeTo).resolvePath());
                }
                PathAddress ownerAddress = context.getCurrentAddress();
                bootTimeScanner = new FileSystemDeploymentService(ownerAddress, relativeTo, new File(pathName), relativePath, null, scheduledExecutorService, (ControlledProcessStateService)context.getServiceRegistry(false).getService(ControlledProcessStateService.SERVICE_NAME).getValue());
                bootTimeScanner.setAutoDeployExplodedContent(autoDeployExp);
                bootTimeScanner.setAutoDeployZippedContent(autoDeployZip);
                bootTimeScanner.setAutoDeployXMLContent(autoDeployXml);
                bootTimeScanner.setDeploymentTimeout(deploymentTimeout);
                bootTimeScanner.setScanInterval(scanInterval);
                bootTimeScanner.setRuntimeFailureCausesRollback(rollback);
            } else {
                bootTimeScanner = null;
            }
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    DeploymentScannerAdd.performRuntime(context, operation, model, scheduledExecutorService, bootTimeScanner);
                    context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
            if (bootTimeScan) {
                AtomicReference<ModelNode> deploymentOperation = new AtomicReference<ModelNode>();
                final AtomicReference<ModelNode> deploymentResults = new AtomicReference<ModelNode>(new ModelNode());
                final CountDownLatch scanDoneLatch = new CountDownLatch(1);
                final CountDownLatch deploymentDoneLatch = new CountDownLatch(1);
                final BootTimeScannerDeployment deploymentOps = new BootTimeScannerDeployment(deploymentOperation, deploymentDoneLatch, deploymentResults, scanDoneLatch);
                scheduledExecutorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            bootTimeScanner.bootTimeScan(deploymentOps);
                        }
                        catch (Throwable t) {
                            DeploymentScannerLogger.ROOT_LOGGER.initialScanFailed(t);
                        }
                        finally {
                            scanDoneLatch.countDown();
                        }
                    }
                });
                boolean interrupted = false;
                boolean asyncCountDown = false;
                try {
                    scanDoneLatch.await();
                    ModelNode op = deploymentOperation.get();
                    if (op != null) {
                        final ModelNode result = new ModelNode();
                        PathAddress opPath = PathAddress.pathAddress((ModelNode)op.get("address"));
                        OperationStepHandler handler = context.getRootResourceRegistration().getOperationHandler(opPath, op.get("operation").asString());
                        context.addStep(result, op, handler, OperationContext.Stage.MODEL);
                        stepCompleted = true;
                        context.completeStep(new OperationContext.ResultHandler(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                                try {
                                    deploymentResults.set(result);
                                }
                                finally {
                                    deploymentDoneLatch.countDown();
                                }
                            }
                        });
                        asyncCountDown = true;
                    } else {
                        stepCompleted = true;
                        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                    }
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    throw new RuntimeException(e);
                }
                finally {
                    if (!asyncCountDown) {
                        deploymentDoneLatch.countDown();
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        if (!stepCompleted) {
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    private void recordCapabilitiesAndRequirements(OperationContext context, Resource resource, AttributeDefinition ... attributes) throws OperationFailedException {
        Set capabilitySet = context.getResourceRegistration().getCapabilities();
        for (RuntimeCapability capability : capabilitySet) {
            if (capability.isDynamicallyNamed()) {
                context.registerCapability(capability.fromBaseCapability(context.getCurrentAddress()));
                continue;
            }
            context.registerCapability(capability);
        }
        ModelNode model = resource.getModel();
        for (AttributeDefinition ad : attributes) {
            if (!model.hasDefined(ad.getName()) && !ad.hasCapabilityRequirements()) continue;
            ad.addCapabilityRequirements(context, resource, model.get(ad.getName()));
        }
    }

    static ScheduledExecutorService createScannerExecutorService() {
        ThreadFactory threadFactory = AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

            @Override
            public ThreadFactory run() {
                return new JBossThreadFactory(new ThreadGroup("DeploymentScanner-threads"), Boolean.FALSE, null, "%G - %t", null, null);
            }
        });
        return Executors.newScheduledThreadPool(2, threadFactory);
    }

    static void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ScheduledExecutorService executorService, FileSystemDeploymentService bootTimeScanner) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String path = DeploymentScannerDefinition.PATH.resolveModelAttribute(context, model).asString();
        Boolean enabled = DeploymentScannerDefinition.SCAN_ENABLED.resolveModelAttribute(context, model).asBoolean();
        Integer interval = DeploymentScannerDefinition.SCAN_INTERVAL.resolveModelAttribute(context, model).asInt();
        String relativeTo = operation.hasDefined("relative-to") ? DeploymentScannerDefinition.RELATIVE_TO.resolveModelAttribute(context, model).asString() : null;
        Boolean autoDeployZip = DeploymentScannerDefinition.AUTO_DEPLOY_ZIPPED.resolveModelAttribute(context, model).asBoolean();
        Boolean autoDeployExp = DeploymentScannerDefinition.AUTO_DEPLOY_EXPLODED.resolveModelAttribute(context, model).asBoolean();
        Boolean autoDeployXml = DeploymentScannerDefinition.AUTO_DEPLOY_XML.resolveModelAttribute(context, model).asBoolean();
        Long deploymentTimeout = DeploymentScannerDefinition.DEPLOYMENT_TIMEOUT.resolveModelAttribute(context, model).asLong();
        Boolean rollback = DeploymentScannerDefinition.RUNTIME_FAILURE_CAUSES_ROLLBACK.resolveModelAttribute(context, model).asBoolean();
        DeploymentScannerService.addService(context, address, relativeTo, path, interval, TimeUnit.MILLISECONDS, autoDeployZip, autoDeployExp, autoDeployXml, enabled, deploymentTimeout, rollback, bootTimeScanner, executorService);
    }

    private static class BootTimeScannerDeployment
    implements DeploymentOperations {
        private final AtomicReference<ModelNode> deploymentOperation;
        private final CountDownLatch deploymentDoneLatch;
        private final AtomicReference<ModelNode> deploymentResults;
        private final CountDownLatch scanDoneLatch;

        public BootTimeScannerDeployment(AtomicReference<ModelNode> deploymentOperation, CountDownLatch deploymentDoneLatch, AtomicReference<ModelNode> deploymentResults, CountDownLatch scanDoneLatch) {
            this.deploymentOperation = deploymentOperation;
            this.deploymentDoneLatch = deploymentDoneLatch;
            this.deploymentResults = deploymentResults;
            this.scanDoneLatch = scanDoneLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Future<ModelNode> deploy(ModelNode operation, ExecutorService executorService) {
            try {
                this.deploymentOperation.set(operation);
                FutureTask<ModelNode> task = new FutureTask<ModelNode>(new Callable<ModelNode>(){

                    @Override
                    public ModelNode call() throws Exception {
                        deploymentDoneLatch.await();
                        return (ModelNode)deploymentResults.get();
                    }
                });
                executorService.submit(task);
                FutureTask<ModelNode> futureTask = task;
                return futureTask;
            }
            finally {
                this.scanDoneLatch.countDown();
            }
        }

        @Override
        public Map<String, Boolean> getDeploymentsStatus() {
            return Collections.emptyMap();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public Set<String> getUnrelatedDeployments(ModelNode owner) {
            return Collections.emptySet();
        }
    }
}

