/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.MaskedAddressValidator;
import org.jboss.as.controller.resource.AbstractSocketBindingResourceDefinition;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.services.net.SocketBindingAddHandler;
import org.jboss.as.server.services.net.SocketBindingResourceDefinition;
import org.jboss.as.server.services.net.SocketBindingService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class BindingAddHandler
extends SocketBindingAddHandler {
    public static final BindingAddHandler INSTANCE = new BindingAddHandler();
    private static final InetAddress ANY_IPV6;

    private BindingAddHandler() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        try {
            BindingAddHandler.installBindingService(context, model, name);
        }
        catch (UnknownHostException e) {
            throw new OperationFailedException(e.toString());
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    static void installBindingService(OperationContext context, ModelNode config, String name) throws UnknownHostException, OperationFailedException {
        CapabilityServiceTarget serviceTarget = context.getCapabilityServiceTarget();
        ModelNode intfNode = AbstractSocketBindingResourceDefinition.INTERFACE.resolveModelAttribute(context, config);
        String intf = intfNode.isDefined() ? intfNode.asString() : null;
        int port = AbstractSocketBindingResourceDefinition.PORT.resolveModelAttribute(context, config).asInt();
        boolean fixedPort = AbstractSocketBindingResourceDefinition.FIXED_PORT.resolveModelAttribute(context, config).asBoolean();
        ModelNode mcastNode = AbstractSocketBindingResourceDefinition.MULTICAST_ADDRESS.resolveModelAttribute(context, config);
        String mcastAddr = mcastNode.isDefined() ? mcastNode.asString() : null;
        int mcastPort = AbstractSocketBindingResourceDefinition.MULTICAST_PORT.resolveModelAttribute(context, config).asInt(0);
        InetAddress mcastInet = mcastAddr == null ? null : InetAddress.getByName(mcastAddr);
        ModelNode mappingsNode = config.get("client-mappings");
        List<ClientMapping> clientMappings = mappingsNode.isDefined() ? BindingAddHandler.parseClientMappings(context, mappingsNode) : null;
        SocketBindingService service = new SocketBindingService(name, port, fixedPort, mcastInet, mcastPort, clientMappings);
        CapabilityServiceBuilder builder = serviceTarget.addCapability(SocketBindingResourceDefinition.SOCKET_BINDING_CAPABILITY);
        builder.setInstance((Service)service);
        if (intf != null) {
            builder.addCapabilityRequirement("org.wildfly.network.interface", NetworkInterfaceBinding.class, service.getInterfaceBinding(), new String[]{intf});
        }
        builder.addCapabilityRequirement("org.wildfly.management.socket-binding-manager", SocketBindingManager.class, service.getSocketBindings()).addAliases(new ServiceName[]{SocketBinding.JBOSS_BINDING_NAME.append(new String[]{name})}).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    static List<ClientMapping> parseClientMappings(OperationContext context, ModelNode mappings) throws OperationFailedException {
        ArrayList<ClientMapping> clientMappings = new ArrayList<ClientMapping>();
        for (ModelNode mappingNode : mappings.asList()) {
            int mask;
            InetAddress sourceAddress;
            ModelNode sourceNode = AbstractSocketBindingResourceDefinition.CLIENT_MAPPING_SOURCE_NETWORK.resolveModelAttribute(context, mappingNode);
            if (sourceNode.isDefined()) {
                MaskedAddressValidator.ParsedResult parsedResult = MaskedAddressValidator.parseMasked((ModelNode)sourceNode);
                sourceAddress = parsedResult.address;
                mask = parsedResult.mask;
            } else {
                sourceAddress = ANY_IPV6;
                mask = 0;
            }
            ModelNode destinationNode = AbstractSocketBindingResourceDefinition.CLIENT_MAPPING_DESTINATION_ADDRESS.resolveModelAttribute(context, mappingNode);
            if (!destinationNode.isDefined()) {
                throw ControllerLogger.ROOT_LOGGER.nullNotAllowed("destination-address");
            }
            String destination = destinationNode.asString();
            ModelNode portNode = AbstractSocketBindingResourceDefinition.CLIENT_MAPPING_DESTINATION_PORT.resolveModelAttribute(context, mappingNode);
            int port = portNode.isDefined() ? portNode.asInt() : -1;
            clientMappings.add(new ClientMapping(sourceAddress, mask, destination, port));
        }
        return clientMappings;
    }

    static {
        try {
            ANY_IPV6 = InetAddress.getByAddress(new byte[16]);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Not possible");
        }
    }
}

