/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.invocation;

import java.io.IOException;
import org.aesh.command.CommandException;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandRuntime;
import org.aesh.command.Executor;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationConfiguration;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.shell.Shell;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.readline.Prompt;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.terminal.Key;
import org.aesh.terminal.tty.Size;

public class DefaultCommandInvocation
implements CommandInvocation {
    private final Shell shell = new DefaultShell();
    private final CommandRuntime<DefaultCommandInvocation> processor;
    private final CommandInvocationConfiguration config;
    private final CommandContainer<DefaultCommandInvocation> commandContainer;

    public DefaultCommandInvocation(CommandRuntime<DefaultCommandInvocation> processor, CommandInvocationConfiguration config, CommandContainer<DefaultCommandInvocation> commandContainer) {
        this.processor = processor;
        this.config = config;
        this.commandContainer = commandContainer;
    }

    @Override
    public Shell getShell() {
        return this.shell;
    }

    @Override
    public void setPrompt(Prompt prompt) {
    }

    @Override
    public Prompt getPrompt() {
        return null;
    }

    @Override
    public String getHelpInfo(String commandName) {
        return this.processor.commandInfo(commandName);
    }

    @Override
    public String getHelpInfo() {
        return this.commandContainer.getParser().parsedCommand().printHelp();
    }

    @Override
    public void stop() {
    }

    @Override
    public KeyAction input() {
        return null;
    }

    @Override
    public String inputLine() {
        return null;
    }

    @Override
    public String inputLine(Prompt prompt) {
        return null;
    }

    @Override
    public void executeCommand(String input) throws CommandNotFoundException, CommandLineParserException, OptionValidatorException, CommandValidatorException, CommandException, InterruptedException, IOException {
        this.processor.executeCommand(input);
    }

    @Override
    public void print(String msg, boolean paging) {
        this.shell.write(msg, paging);
    }

    @Override
    public void println(String msg, boolean paging) {
        this.shell.writeln(msg, paging);
    }

    public Executor<? extends CommandInvocation> buildExecutor(String line) throws CommandNotFoundException, CommandLineParserException, OptionValidatorException, CommandValidatorException, IOException {
        return this.processor.buildExecutor(line);
    }

    @Override
    public CommandInvocationConfiguration getConfiguration() {
        return this.config;
    }

    private static class DefaultShell
    implements Shell {
        private DefaultShell() {
        }

        @Override
        public void write(String out, boolean paging) {
            System.out.print(out);
        }

        @Override
        public void writeln(String out, boolean paging) {
            System.out.println(out);
        }

        @Override
        public void write(int[] out) {
        }

        @Override
        public void write(char out) {
            System.out.println(out);
        }

        @Override
        public String readLine() {
            return null;
        }

        @Override
        public String readLine(Prompt prompt) {
            return null;
        }

        @Override
        public Key read() {
            return null;
        }

        @Override
        public Key read(Prompt prompt) {
            return null;
        }

        @Override
        public boolean enableAlternateBuffer() {
            return false;
        }

        @Override
        public boolean enableMainBuffer() {
            return false;
        }

        @Override
        public Size size() {
            return new Size(1, -1);
        }

        @Override
        public void clear() {
        }
    }
}

