/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.formatters;

import java.util.Iterator;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.ElementAttributeMarshaller;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.PropertyAttributeDefinition;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.as.logging.capabilities.Capabilities;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.logmanager.PropertyValues;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.PropertyConfigurable;
import org.jboss.logmanager.formatters.StructuredFormatter;

public abstract class StructuredFormatterResourceDefinition
extends TransformerResourceDefinition {
    public static final PropertyAttributeDefinition DATE_FORMAT = ((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("date-format", ModelType.STRING, true).setAllowExpression(true)).setPropertyName("dateFormat").build();
    public static final PropertyAttributeDefinition EXCEPTION_OUTPUT_TYPE = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("exception-output-type", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode("detailed"))).setPropertyName("exceptionOutputType").setResolver(new ModelNodeResolver<String>(){

        @Override
        public String resolveValue(OperationContext context, ModelNode value) throws OperationFailedException {
            String exceptionType = value.asString();
            if ("detailed".equals(exceptionType)) {
                return StructuredFormatter.ExceptionOutputType.DETAILED.name();
            }
            if ("formatted".equals(exceptionType)) {
                return StructuredFormatter.ExceptionOutputType.FORMATTED.name();
            }
            if ("detailed-and-formatted".equals(exceptionType)) {
                return StructuredFormatter.ExceptionOutputType.DETAILED_AND_FORMATTED.name();
            }
            throw LoggingLogger.ROOT_LOGGER.invalidExceptionOutputType(exceptionType);
        }
    }).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"detailed", "formatted", "detailed-and-formatted"}))).build();
    private static final SimpleAttributeDefinition EXCEPTION = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exception", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition EXCEPTION_CAUSED_BY = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exception-caused-by", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition EXCEPTION_CIRCULAR_REFERENCE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exception-circular-reference", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition EXCEPTION_FRAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exception-frame", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition EXCEPTION_FRAME_CLASS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exception-frame-class", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition EXCEPTION_FRAME_LINE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exception-frame-line", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition EXCEPTION_FRAME_METHOD = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exception-frame-method", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition EXCEPTION_FRAMES = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exception-frames", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition EXCEPTION_MESSAGE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exception-message", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition EXCEPTION_REFERENCE_ID = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exception-reference-id", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition EXCEPTION_SUPPRESSED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exception-suppressed", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition EXCEPTION_TYPE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exception-type", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition HOST_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"host-name", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition LEVEL = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"level", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition LOGGER_CLASS_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"logger-class-name", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition LOGGER_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"logger-name", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition MDC = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"mdc", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition MESSAGE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"message", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition NDC = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"ndc", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition PROCESS_ID = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"process-id", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition PROCESS_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"process-name", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition RECORD = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"record", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition SEQUENCE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"sequence", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition SOURCE_CLASS_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-class-name", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition SOURCE_FILE_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-file-name", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition SOURCE_LINE_NUMBER = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-line-number", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition SOURCE_METHOD_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-method-name", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition SOURCE_MODULE_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-module-name", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition SOURCE_MODULE_VERSION = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-module-version", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition STACK_TRACE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"stack-trace", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition THREAD_ID = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"thread-id", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition THREAD_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"thread-name", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition TIMESTAMP = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"timestamp", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    public static final ObjectTypeAttributeDefinition KEY_OVERRIDES = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.create((String)"key-overrides", (AttributeDefinition[])new AttributeDefinition[]{EXCEPTION, EXCEPTION_CAUSED_BY, EXCEPTION_CIRCULAR_REFERENCE, EXCEPTION_FRAME, EXCEPTION_FRAME_CLASS, EXCEPTION_FRAME_LINE, EXCEPTION_FRAME_METHOD, EXCEPTION_FRAMES, EXCEPTION_MESSAGE, EXCEPTION_REFERENCE_ID, EXCEPTION_SUPPRESSED, EXCEPTION_TYPE, HOST_NAME, LEVEL, LOGGER_CLASS_NAME, LOGGER_NAME, MDC, MESSAGE, NDC, PROCESS_ID, PROCESS_NAME, RECORD, SEQUENCE, SOURCE_CLASS_NAME, SOURCE_FILE_NAME, SOURCE_LINE_NUMBER, SOURCE_METHOD_NAME, SOURCE_MODULE_NAME, SOURCE_MODULE_VERSION, STACK_TRACE, THREAD_ID, THREAD_NAME, TIMESTAMP}).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    public static final SimpleMapAttributeDefinition META_DATA = ((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("meta-data", ModelType.STRING, true).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.PropertiesAttributeMarshaller("meta-data", "property", true))).build();
    public static final PropertyAttributeDefinition PRETTY_PRINT = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("pretty-print", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setPropertyName("prettyPrint").build();
    public static final PropertyAttributeDefinition PRINT_DETAILS = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("print-details", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setPropertyName("printDetails").build();
    public static final PropertyAttributeDefinition RECORD_DELIMITER = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("record-delimiter", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode("\n"))).setPropertyName("recordDelimiter").build();
    public static final PropertyAttributeDefinition ZONE_ID = ((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("zone-id", ModelType.STRING, true).setAllowExpression(true)).setPropertyName("zoneId").build();
    private static final AttributeDefinition[] DEFAULT_ATTRIBUTES = new AttributeDefinition[]{DATE_FORMAT, EXCEPTION_OUTPUT_TYPE, KEY_OVERRIDES, META_DATA, PRETTY_PRINT, PRINT_DETAILS, RECORD_DELIMITER, ZONE_ID};
    private static final OperationStepHandler REMOVE = new LoggingOperations.LoggingRemoveOperationStepHandler(){

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            FormatterConfiguration configuration = logContextConfiguration.getFormatterConfiguration(name);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.formatterNotFound(name));
            }
            logContextConfiguration.removeFormatterConfiguration(name);
        }
    };
    private final AttributeDefinition[] attributes;
    private final OperationStepHandler writeHandler;

    StructuredFormatterResourceDefinition(PathElement pathElement, String descriptionPrefix, Class<? extends StructuredFormatter> type) {
        this(pathElement, descriptionPrefix, type, new AttributeDefinition[0]);
    }

    StructuredFormatterResourceDefinition(PathElement pathElement, String descriptionPrefix, Class<? extends StructuredFormatter> type, AttributeDefinition ... additionalAttributes) {
        super(new SimpleResourceDefinition.Parameters(pathElement, LoggingExtension.getResourceDescriptionResolver(descriptionPrefix)).setAddHandler((OperationStepHandler)new AddStructuredFormatterStepHandler(type, Logging.join(DEFAULT_ATTRIBUTES, additionalAttributes))).setRemoveHandler(REMOVE).setCapabilities(new RuntimeCapability[]{Capabilities.FORMATTER_CAPABILITY}));
        this.attributes = Logging.join(DEFAULT_ATTRIBUTES, additionalAttributes);
        this.writeHandler = new WriteStructuredFormatterStepHandler(this.attributes);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attribute : this.attributes) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, this.writeHandler);
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
    }

    @Override
    public void registerTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder rootResourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
        switch (modelVersion) {
            case VERSION_5_0_0: {
                rootResourceBuilder.rejectChildResource(this.getPathElement());
                loggingProfileBuilder.rejectChildResource(this.getPathElement());
            }
        }
    }

    private static String modelValueToMetaData(ModelNode metaData) {
        if (metaData.getType() != ModelType.OBJECT) {
            return null;
        }
        List properties = metaData.asPropertyList();
        StringBuilder result = new StringBuilder();
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            PropertyValues.escapeKey((StringBuilder)result, (String)property.getName());
            result.append('=');
            ModelNode value = property.getValue();
            if (value.isDefined()) {
                PropertyValues.escapeValue((StringBuilder)result, (String)value.asString());
            }
            if (!iterator.hasNext()) continue;
            result.append(',');
        }
        return result.toString();
    }

    private static class WriteStructuredFormatterStepHandler
    extends LoggingOperations.LoggingWriteAttributeHandler {
        WriteStructuredFormatterStepHandler(AttributeDefinition[] attributes) {
            super(attributes);
        }

        @Override
        protected boolean applyUpdate(OperationContext context, String attributeName, String addressName, ModelNode value, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            FormatterConfiguration configuration = logContextConfiguration.getFormatterConfiguration(addressName);
            if (attributeName.equals(META_DATA.getName())) {
                String metaData = StructuredFormatterResourceDefinition.modelValueToMetaData(value);
                if (metaData != null) {
                    configuration.setPropertyValueString("metaData", metaData);
                } else {
                    configuration.removeProperty("metaData");
                }
            } else {
                if (attributeName.equals(KEY_OVERRIDES.getName())) {
                    return true;
                }
                for (AttributeDefinition attribute : DEFAULT_ATTRIBUTES) {
                    if (!attribute.getName().equals(attributeName)) continue;
                    if (attribute instanceof PropertyAttributeDefinition) {
                        PropertyAttributeDefinition propertyAttribute = (PropertyAttributeDefinition)attribute;
                        if (value.isDefined()) {
                            ModelNodeResolver<String> resolver = propertyAttribute.resolver();
                            String resolvedValue = value.asString();
                            if (resolver != null) {
                                resolvedValue = resolver.resolveValue(context, value);
                            }
                            configuration.setPropertyValueString(propertyAttribute.getPropertyName(), resolvedValue);
                            break;
                        }
                        configuration.removeProperty(propertyAttribute.getPropertyName());
                        break;
                    }
                    if (value.isDefined()) {
                        configuration.setPropertyValueString(attributeName, value.asString());
                        break;
                    }
                    configuration.removeProperty(attributeName);
                    break;
                }
            }
            return false;
        }
    }

    private static class AddStructuredFormatterStepHandler
    extends LoggingOperations.LoggingAddOperationStepHandler {
        private final Class<? extends StructuredFormatter> type;

        private AddStructuredFormatterStepHandler(Class<? extends StructuredFormatter> type, AttributeDefinition[] attributes) {
            super(attributes);
            this.type = type;
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String name;
            String keyOverrides = null;
            if (model.hasDefined(KEY_OVERRIDES.getName())) {
                keyOverrides = StructuredFormatterResourceDefinition.modelValueToMetaData(KEY_OVERRIDES.resolveModelAttribute(context, model));
            }
            if ((name = context.getCurrentAddressValue()).endsWith("-wfcore-pattern-formatter")) {
                throw LoggingLogger.ROOT_LOGGER.illegalFormatterName();
            }
            FormatterConfiguration configuration = logContextConfiguration.getFormatterConfiguration(name);
            String className = this.type.getName();
            if (configuration == null) {
                LoggingLogger.ROOT_LOGGER.tracef("Adding formatter '%s' at '%s'", name, context.getCurrentAddress());
                if (keyOverrides == null) {
                    configuration = logContextConfiguration.addFormatterConfiguration(null, className, name, new String[0]);
                } else {
                    configuration = logContextConfiguration.addFormatterConfiguration(null, className, name, new String[]{"keyOverrides"});
                    configuration.setPropertyValueString("keyOverrides", keyOverrides);
                }
            } else if (AddStructuredFormatterStepHandler.isSamePropertyValue(configuration, "keyOverrides", keyOverrides)) {
                LoggingLogger.ROOT_LOGGER.tracef("Removing then adding formatter '%s' at '%s'", name, context.getCurrentAddress());
                logContextConfiguration.removeFormatterConfiguration(name);
                configuration = logContextConfiguration.addFormatterConfiguration(null, className, name, new String[]{"keyOverrides"});
                configuration.setPropertyValueString("keyOverrides", keyOverrides);
            }
            for (AttributeDefinition attribute : this.attributes) {
                if (attribute == META_DATA) {
                    String metaData = StructuredFormatterResourceDefinition.modelValueToMetaData(META_DATA.resolveModelAttribute(context, model));
                    if (metaData != null) {
                        if (!AddStructuredFormatterStepHandler.isSamePropertyValue(configuration, "metaData", metaData)) continue;
                        configuration.setPropertyValueString("metaData", metaData);
                        continue;
                    }
                    configuration.removeProperty("metaData");
                    continue;
                }
                if (attribute == KEY_OVERRIDES) continue;
                if (attribute instanceof PropertyAttributeDefinition) {
                    ((PropertyAttributeDefinition)attribute).setPropertyValue(context, model, (PropertyConfigurable)configuration);
                    continue;
                }
                ModelNode value = attribute.resolveModelAttribute(context, model);
                if (value.isDefined()) {
                    if (!AddStructuredFormatterStepHandler.isSamePropertyValue(configuration, attribute.getName(), value.asString())) continue;
                    configuration.setPropertyValueString(attribute.getName(), value.asString());
                    continue;
                }
                configuration.removeProperty(attribute.getName());
            }
        }

        private static boolean isSamePropertyValue(FormatterConfiguration configuration, String name, String value) {
            String currentValue = configuration.getPropertyValueString(name);
            if (currentValue == null) {
                return value != null;
            }
            return currentValue.equals(value);
        }
    }
}

