/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.shell;

import org.aesh.command.impl.operator.OutputDelegate;
import org.aesh.command.shell.Shell;
import org.aesh.readline.Prompt;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.tty.Size;
import org.aesh.utils.Config;

public class ShellOutputDelegate
implements Shell {
    private final Shell delegate;
    private final OutputDelegate output;

    public ShellOutputDelegate(Shell delegate, OutputDelegate output) {
        this.delegate = delegate;
        this.output = output;
    }

    private void doWrite(String out) {
        this.output.write(out);
    }

    @Override
    public void write(String out, boolean paging) {
        this.doWrite(out);
    }

    @Override
    public void writeln(String out, boolean paging) {
        this.doWrite(out + Config.getLineSeparator());
    }

    @Override
    public void write(int[] out) {
        this.doWrite(Parser.fromCodePoints((int[])out));
    }

    @Override
    public void write(char out) {
        this.output.write(String.valueOf(out));
    }

    @Override
    public String readLine() throws InterruptedException {
        return this.delegate.readLine();
    }

    @Override
    public String readLine(Prompt prompt) throws InterruptedException {
        return this.delegate.readLine(prompt);
    }

    @Override
    public Key read() throws InterruptedException {
        return this.delegate.read();
    }

    @Override
    public Key read(Prompt prompt) throws InterruptedException {
        return this.delegate.read(prompt);
    }

    @Override
    public boolean enableAlternateBuffer() {
        return false;
    }

    @Override
    public boolean enableMainBuffer() {
        return false;
    }

    @Override
    public Size size() {
        return this.delegate.size();
    }

    @Override
    public void clear() {
    }
}

