/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.spec.InvalidParameterSpecException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ELY", length=5)
interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security");

    @Message(id=9, value="Invalid name \"%s\"")
    public IllegalArgumentException generalInvalidName(String var1);

    @Message(id=3025, value="Iteration count not specified for password based encryption")
    public IllegalArgumentException iterationCountNotSpecified();

    @Message(id=3026, value="Salt not specified for password based encryption")
    public IllegalArgumentException saltNotSpecified();

    @Message(id=3027, value="Initial key not specified for password based encryption")
    public IllegalArgumentException initialKeyNotSpecified();

    @Message(id=3028, value="Security provider \"%s\" doesn't exist")
    public IllegalArgumentException securityProviderDoesnExist(String var1);

    @Message(id=3029, value="No such key algorithm \"%s\"")
    public IllegalArgumentException noSuchKeyAlgorithm(String var1, @Cause GeneralSecurityException var2);

    @Message(id=3030, value="I/O operation failed: closed")
    public IOException closed();

    @Message(id=3032, value="Base64 string created with unsupported PicketBox version \"%s\"")
    public IllegalArgumentException wrongBase64InPBCompatibleMode(String var1);

    @Message(id=4020, value="Mechanism \"%s\" not supported by transformation mapper")
    public IllegalArgumentException mechanismNotSupported(String var1);

    @Message(id=8030, value="Failed to encode parameter specification")
    public InvalidParameterSpecException failedToEncode(@Cause Throwable var1);

    @Message(id=8031, value="Failed to decode parameter specification")
    public IOException failedToDecode(@Cause Throwable var1);

    @Message(id=8032, value="Invalid parameter specification type (expected %s, got %s)")
    public InvalidParameterSpecException invalidParameterSpec(Class<?> var1, Class<?> var2);

    @Message(id=8033, value="Invalid format given (expected %s, got %s)")
    public IOException invalidFormat(String var1, String var2);

    @Message(id=8034, value="Algorithm parameters instance not initialized")
    public IllegalStateException algorithmParametersNotInitialized();
}

