/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import java.util.Collection;
import java.util.Map;
import org.jboss.as.web.host.ServletBuilder;
import org.jboss.as.web.host.WebDeploymentBuilder;
import org.jboss.as.web.host.WebDeploymentController;
import org.jboss.as.web.host.WebHost;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.deployment.GlobalRequestControllerHandler;

class WebHostService
implements Service<WebHost>,
WebHost {
    private final InjectedValue<Server> server = new InjectedValue();
    private final InjectedValue<Host> host = new InjectedValue();
    private final InjectedValue<RequestController> requestControllerInjectedValue = new InjectedValue();
    private volatile ControlPoint controlPoint;

    WebHostService() {
    }

    protected InjectedValue<Server> getServer() {
        return this.server;
    }

    protected InjectedValue<Host> getHost() {
        return this.host;
    }

    public WebDeploymentController addWebDeployment(WebDeploymentBuilder webDeploymentBuilder) throws Exception {
        DeploymentInfo d = new DeploymentInfo();
        d.setDeploymentName(webDeploymentBuilder.getContextRoot());
        d.setContextPath(webDeploymentBuilder.getContextRoot());
        d.setClassLoader(webDeploymentBuilder.getClassLoader());
        d.setResourceManager((ResourceManager)new PathResourceManager(webDeploymentBuilder.getDocumentRoot().toPath().toAbsolutePath(), 0x100000L));
        d.setIgnoreFlush(false);
        for (ServletBuilder servlet : webDeploymentBuilder.getServlets()) {
            ServletInfo s = servlet.getServlet() == null ? new ServletInfo(servlet.getServletName(), servlet.getServletClass()) : new ServletInfo(servlet.getServletName(), servlet.getServletClass(), (InstanceFactory)new ImmediateInstanceFactory((Object)servlet.getServlet()));
            if (servlet.isForceInit()) {
                s.setLoadOnStartup(Integer.valueOf(1));
            }
            s.addMappings((Collection)servlet.getUrlMappings());
            for (Map.Entry param : servlet.getInitParams().entrySet()) {
                s.addInitParam((String)param.getKey(), (String)param.getValue());
            }
            d.addServlet(s);
        }
        if (this.controlPoint != null) {
            d.addOuterHandlerChainWrapper(GlobalRequestControllerHandler.wrapper(this.controlPoint, webDeploymentBuilder.getAllowRequestPredicates()));
        }
        return new WebDeploymentControllerImpl(d);
    }

    public void start(StartContext context) throws StartException {
        RequestController rq = (RequestController)this.requestControllerInjectedValue.getOptionalValue();
        if (rq != null) {
            this.controlPoint = rq.getControlPoint("", "org.wildfly.undertow.webhost." + ((Server)this.server.getValue()).getName() + "." + ((Host)this.host.getValue()).getName());
        }
    }

    public void stop(StopContext context) {
        if (this.controlPoint != null) {
            ((RequestController)this.requestControllerInjectedValue.getValue()).removeControlPoint(this.controlPoint);
        }
    }

    public WebHost getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<RequestController> getRequestControllerInjectedValue() {
        return this.requestControllerInjectedValue;
    }

    private class WebDeploymentControllerImpl
    implements WebDeploymentController {
        private final DeploymentInfo deploymentInfo;
        private volatile DeploymentManager manager;

        private WebDeploymentControllerImpl(DeploymentInfo deploymentInfo) {
            this.deploymentInfo = deploymentInfo;
        }

        public void create() throws Exception {
            ServletContainer container = ((Server)WebHostService.this.server.getValue()).getServletContainer().getValue().getServletContainer();
            this.manager = container.addDeployment(this.deploymentInfo);
            this.manager.deploy();
        }

        public void start() throws Exception {
            HttpHandler handler = this.manager.start();
            ((Host)WebHostService.this.host.getValue()).registerDeployment(this.manager.getDeployment(), handler);
        }

        public void stop() throws Exception {
            ((Host)WebHostService.this.host.getValue()).unregisterDeployment(this.manager.getDeployment());
            this.manager.stop();
        }

        public void destroy() throws Exception {
            this.manager.undeploy();
            ServletContainer container = ((Server)WebHostService.this.server.getValue()).getServletContainer().getValue().getServletContainer();
            container.removeDeployment(this.deploymentInfo);
        }
    }
}

