/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.DynamicNameMappers;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ValueExpression;
import org.wildfly.extension.undertow.AccessLogAdd;
import org.wildfly.extension.undertow.AccessLogRemove;
import org.wildfly.extension.undertow.AccessLogService;
import org.wildfly.extension.undertow.PredicateValidator;
import org.wildfly.extension.undertow.UndertowExtension;

class AccessLogDefinition
extends PersistentResourceDefinition {
    static final RuntimeCapability<Void> ACCESS_LOG_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.host.access-log", (boolean)true, AccessLogService.class).setDynamicNameMapper(DynamicNameMappers.GRAND_PARENT).build();
    protected static final SimpleAttributeDefinition PATTERN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pattern", ModelType.STRING, true).setDefaultValue(new ModelNode("common"))).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setRestartAllServices()).build();
    protected static final SimpleAttributeDefinition WORKER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("worker", ModelType.STRING).setRequired(false)).setRestartAllServices()).setValidator((ParameterValidator)new StringLengthValidator(1))).setDefaultValue(new ModelNode("default"))).setCapabilityReference("org.wildfly.io.worker")).build();
    protected static final SimpleAttributeDefinition PREFIX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("prefix", ModelType.STRING, true).setDefaultValue(new ModelNode("access_log."))).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setAllowExpression(true)).setRestartAllServices()).build();
    protected static final SimpleAttributeDefinition SUFFIX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("suffix", ModelType.STRING, true).setDefaultValue(new ModelNode("log"))).setAllowExpression(true)).setRestartAllServices()).build();
    protected static final SimpleAttributeDefinition ROTATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rotate", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(true))).setAllowExpression(true)).setRestartAllServices()).build();
    protected static final SimpleAttributeDefinition DIRECTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("directory", ModelType.STRING).setRequired(false)).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setDefaultValue(new ModelNode(new ValueExpression("${jboss.server.log.dir}")))).setAllowExpression(true)).setRestartAllServices()).build();
    protected static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", ModelType.STRING).setRequired(false)).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setAllowExpression(true)).setRestartAllServices()).build();
    protected static final SimpleAttributeDefinition USE_SERVER_LOG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-server-log", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setRestartAllServices()).build();
    protected static final SimpleAttributeDefinition EXTENDED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("extended", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setRestartAllServices()).build();
    protected static final SimpleAttributeDefinition PREDICATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("predicate", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)PredicateValidator.INSTANCE)).setRestartAllServices()).build();
    static final Collection<SimpleAttributeDefinition> ATTRIBUTES = Arrays.asList(WORKER, PATTERN, PREFIX, SUFFIX, ROTATE, DIRECTORY, USE_SERVER_LOG, RELATIVE_TO, EXTENDED, PREDICATE);
    static final AccessLogDefinition INSTANCE = new AccessLogDefinition();
    private final List<AccessConstraintDefinition> accessConstraints;

    private AccessLogDefinition() {
        super(new PersistentResourceDefinition.Parameters(UndertowExtension.PATH_ACCESS_LOG, (ResourceDescriptionResolver)UndertowExtension.getResolver("access-log")).setAddHandler((OperationStepHandler)AccessLogAdd.INSTANCE).setRemoveHandler((OperationStepHandler)AccessLogRemove.INSTANCE).setCapabilities(new RuntimeCapability[]{ACCESS_LOG_CAPABILITY}));
        SensitivityClassification sc = new SensitivityClassification("undertow", "web-access-log", false, false, false);
        this.accessConstraints = new SensitiveTargetAccessConstraintDefinition(sc).wrapAsList();
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }
}

