/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.filters;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;

class FilterReferenceRecorder {
    private final Map<String, Set<String>> filterRefs = new HashMap<String, Set<String>>();

    FilterReferenceRecorder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getFilterReferences(PathAddress filterAddress) {
        String key = FilterReferenceRecorder.formatName(filterAddress);
        LinkedHashSet<String> refs = new LinkedHashSet<String>();
        Map<String, Set<String>> map = this.filterRefs;
        synchronized (map) {
            if (this.filterRefs.containsKey(key)) {
                refs.addAll((Collection<String>)this.filterRefs.get(key));
            }
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerFilter(String filterName, PathAddress referenceAddress) {
        String key = FilterReferenceRecorder.formatName(referenceAddress, filterName);
        Map<String, Set<String>> map = this.filterRefs;
        synchronized (map) {
            Set filters = this.filterRefs.compute(key, (value, values) -> new LinkedHashSet());
            filters.add(referenceAddress.toCLIStyleString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterFilter(String filterName, PathAddress referenceAddress) {
        String key = FilterReferenceRecorder.formatName(referenceAddress, filterName);
        Map<String, Set<String>> map = this.filterRefs;
        synchronized (map) {
            Set<String> filters = this.filterRefs.get(key);
            if (filters != null) {
                filters.remove(referenceAddress.toCLIStyleString());
                if (filters.isEmpty()) {
                    this.filterRefs.remove(key);
                }
            }
        }
    }

    private static String formatName(PathAddress address, String dynamicName) {
        for (PathElement pathElement : address) {
            if (!"logging-profile".equals(pathElement.getKey())) continue;
            return pathElement.getValue() + "." + dynamicName;
        }
        return dynamicName;
    }

    private static String formatName(PathAddress address) {
        return FilterReferenceRecorder.formatName(address, address.getLastElement().getValue());
    }
}

