/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert.acme;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.x500.cert.acme.AcmeException;
import org.wildfly.security.x500.cert.acme.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unableToDetermineKeySize$str() {
        return "ELY10016: Unable to determine key size";
    }

    @Override
    public final IllegalArgumentException unableToDetermineKeySize() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToDetermineKeySize$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String unableToDetermineDefaultCompatibleSignatureAlgorithmName$str() {
        return "ELY10019: Unable to determine default compatible signature algorithm name for key algorithm name \"%s\"";
    }

    @Override
    public final IllegalArgumentException unableToDetermineDefaultCompatibleSignatureAlgorithmName(String keyAlgorithmName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToDetermineDefaultCompatibleSignatureAlgorithmName$str(), keyAlgorithmName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String acmeAccountKeyPairGenerationFailed$str() {
        return "ELY10029: Failed to generate ACME account key pair";
    }

    @Override
    public final IllegalArgumentException acmeAccountKeyPairGenerationFailed(Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.acmeAccountKeyPairGenerationFailed$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noAcmeServerUrlGiven$str() {
        return "ELY10030: No ACME server URL given";
    }

    @Override
    public final IllegalArgumentException noAcmeServerUrlGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noAcmeServerUrlGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedAcmeAccountSignatureAlgorithm$str() {
        return "ELY10031: Unsupported ACME account signature algorithm \"%s\"";
    }

    @Override
    public final IllegalArgumentException unsupportedAcmeAccountSignatureAlgorithm(String signatureAlgorithm) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsupportedAcmeAccountSignatureAlgorithm$str(), signatureAlgorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCreateAcmeSignature$str() {
        return "ELY10032: Unable to create ACME signature";
    }

    @Override
    public final IllegalArgumentException unableToCreateAcmeSignature(Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToCreateAcmeSignature$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToRetrieveAcmeServerDirectoryUrls$str() {
        return "ELY10033: Unable to retrieve ACME server directory URLs";
    }

    @Override
    public final AcmeException unableToRetrieveAcmeServerDirectoryUrls(Exception cause) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unableToRetrieveAcmeServerDirectoryUrls$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noNonceProvidedByAcmeServer$str() {
        return "ELY10034: No nonce provided by ACME server";
    }

    @Override
    public final AcmeException noNonceProvidedByAcmeServer() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.noNonceProvidedByAcmeServer$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noAccountLocationUrlProvidedByAcmeServer$str() {
        return "ELY10035: No account location URL provided by ACME server";
    }

    @Override
    public final AcmeException noAccountLocationUrlProvidedByAcmeServer() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.noAccountLocationUrlProvidedByAcmeServer$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToObtainNewNonceFromAcmeServer$str() {
        return "ELY10036: Unable to obtain new nonce from ACME server";
    }

    @Override
    public final AcmeException unableToObtainNewNonceFromAcmeServer() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unableToObtainNewNonceFromAcmeServer$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToObtainJsonResponseFromAcmeServer$str() {
        return "ELY10037: Unable to obtain JSON response from ACME server";
    }

    @Override
    public final AcmeException unableToObtainJsonResponseFromAcmeServer(Exception cause) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unableToObtainJsonResponseFromAcmeServer$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedResponseCodeFromAcmeServer$str() {
        return "ELY10038: Unexpected HTTP status code in response from ACME server \"%d\": \"%s\"";
    }

    @Override
    public final AcmeException unexpectedResponseCodeFromAcmeServer(int responseCode, String responseMessage) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unexpectedResponseCodeFromAcmeServer$str(), responseCode, responseMessage));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String badAcmeNonce$str() {
        return "ELY10039: Bad ACME replay nonce, maximum retries attempted";
    }

    @Override
    public final AcmeException badAcmeNonce() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.badAcmeNonce$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedContentTypeFromAcmeServer$str() {
        return "ELY10040: Unexpected content type in response from ACME server \"%s\"";
    }

    @Override
    public final AcmeException unexpectedContentTypeFromAcmeServer(String contentType) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unexpectedContentTypeFromAcmeServer$str(), contentType));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidContentTypeFromAcmeServer$str() {
        return "ELY10041: Invalid content type in response from ACME server";
    }

    @Override
    public final AcmeException invalidContentTypeFromAcmeServer() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.invalidContentTypeFromAcmeServer$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String domainNameIsNull$str() {
        return "ELY10042: Domain name is null";
    }

    @Override
    public final AcmeException domainNameIsNull() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.domainNameIsNull$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String domainNamesIsEmpty$str() {
        return "ELY10043: Domain names is empty";
    }

    @Override
    public final AcmeException domainNamesIsEmpty() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.domainNamesIsEmpty$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noCertificateUrlProvidedByAcmeServer$str() {
        return "ELY10044: No certificate URL provided by ACME server";
    }

    @Override
    public final AcmeException noCertificateUrlProvidedByAcmeServer() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.noCertificateUrlProvidedByAcmeServer$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noCertificateWillBeIssuedByAcmeServer$str() {
        return "ELY10045: No certificate will be issued by the ACME server";
    }

    @Override
    public final AcmeException noCertificateWillBeIssuedByAcmeServer() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.noCertificateWillBeIssuedByAcmeServer$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToGetEncodedFormOfCertificateToBeRevoked$str() {
        return "ELY10046: Unable to get encoded form of certificate to be revoked";
    }

    @Override
    public final AcmeException unableToGetEncodedFormOfCertificateToBeRevoked(Exception cause) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unableToGetEncodedFormOfCertificateToBeRevoked$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToDetermineKeyAuthorizationString$str() {
        return "ELY10047: Unable to determine key authorization string";
    }

    @Override
    public final AcmeException unableToDetermineKeyAuthorizationString(Exception cause) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unableToDetermineKeyAuthorizationString$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String challengeResponseFailedValidationByAcmeServer$str() {
        return "ELY10048: Challenge response failed validation by the ACME server";
    }

    @Override
    public final AcmeException challengeResponseFailedValidationByAcmeServer() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.challengeResponseFailedValidationByAcmeServer$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToDownloadCertificateChainFromAcmeServer$str() {
        return "ELY10049: Unable to download certificate chain from ACME server";
    }

    @Override
    public final AcmeException unableToDownloadCertificateChainFromAcmeServer(Exception cause) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unableToDownloadCertificateChainFromAcmeServer$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String acmeAccountDoesNotExist$str() {
        return "ELY10050: ACME account does not exist";
    }

    @Override
    public final AcmeException acmeAccountDoesNotExist() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.acmeAccountDoesNotExist$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String userActionRequired$str() {
        return "ELY10051: User action required since the ACME server's terms of service have changed, visit \"%s\" for details";
    }

    @Override
    public final AcmeException userActionRequired(String url) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.userActionRequired$str(), url));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String rateLimitExceededTryAgainLater$str() {
        return "ELY10052: Rate limit has been exceeded, try again after \"%s\"";
    }

    @Override
    public final AcmeException rateLimitExceededTryAgainLater(Instant instant) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.rateLimitExceededTryAgainLater$str(), instant));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String rateLimitExceeded$str() {
        return "ELY10053: Rate limit has been exceeded";
    }

    @Override
    public final AcmeException rateLimitExceeded() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.rateLimitExceeded$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String resourceNotSupportedByAcmeServer$str() {
        return "ELY10054: Resource not supported by the ACME server \"%s\"";
    }

    @Override
    public final AcmeException resourceNotSupportedByAcmeServer(String resource) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.resourceNotSupportedByAcmeServer$str(), resource));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedAcmeAccountPublicKeyType$str() {
        return "ELY10055: Unsupported ACME account public key type \"%s\"";
    }

    @Override
    public final IllegalArgumentException unsupportedAcmeAccountPublicKeyType(String keyAlgorithmName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsupportedAcmeAccountPublicKeyType$str(), keyAlgorithmName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToDetermineCurveParameterFromAlgHeader$str() {
        return "ELY10056: Unable to determine curve parameter from alg header \"%s\"";
    }

    @Override
    public final IllegalArgumentException unableToDetermineCurveParameterFromAlgHeader(String algHeader) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToDetermineCurveParameterFromAlgHeader$str(), algHeader));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noAcmeServerStagingUrlGiven$str() {
        return "ELY10057: No ACME server staging URL given";
    }

    @Override
    public final AcmeException noAcmeServerStagingUrlGiven() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.noAcmeServerStagingUrlGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

