/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.handlers.HandlersAttributeMarshaller;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.logging.resolvers.HandlerResolver;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.config.PropertyConfigurable;

public class LogHandlerListAttributeDefinition
extends SimpleListAttributeDefinition
implements ConfigurationProperty<Set<String>> {
    private final String propertyName;
    private final HandlerResolver resolver = HandlerResolver.INSTANCE;

    private LogHandlerListAttributeDefinition(Builder builder, AttributeDefinition valueType) {
        super((ListAttributeDefinition.Builder)builder, valueType);
        this.propertyName = builder.propertyName;
    }

    @Override
    public ModelNodeResolver<Set<String>> resolver() {
        return this.resolver;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Set<String> resolvePropertyValue(OperationContext context, ModelNode model) throws OperationFailedException {
        Object result = Collections.emptySet();
        ModelNode value = this.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            result = this.resolver.resolveValue(context, value);
        }
        return result;
    }

    @Override
    public void setPropertyValue(OperationContext context, ModelNode model, PropertyConfigurable configuration) {
        throw LoggingLogger.ROOT_LOGGER.unsupportedMethod("setPropertyValue", this.getClass().getName());
    }

    public static class Builder
    extends ListAttributeDefinition.Builder<Builder, LogHandlerListAttributeDefinition> {
        private final AttributeDefinition valueType;
        private String propertyName;

        Builder(AttributeDefinition valueType, String name) {
            super(name);
            this.valueType = valueType;
            this.setElementValidator(valueType.getValidator());
        }

        public static Builder of(String name, AttributeDefinition valueType) {
            return new Builder(valueType, name);
        }

        public LogHandlerListAttributeDefinition build() {
            if (this.propertyName == null) {
                this.propertyName = this.getName();
            }
            if (this.getAttributeMarshaller() == null) {
                this.setAttributeMarshaller((AttributeMarshaller)new HandlersAttributeMarshaller(this.valueType));
            }
            return new LogHandlerListAttributeDefinition(this, this.valueType);
        }

        public Builder setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }
    }
}

