/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.validators;

import java.util.regex.Pattern;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class RegexValidator
extends ModelTypeValidator {
    private final Pattern pattern;

    public RegexValidator(ModelType type, boolean nullable, boolean allowExpressions, String pattern) {
        super(type, nullable, allowExpressions);
        this.pattern = Pattern.compile(pattern, 2);
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        String stringValue;
        super.validateParameter(parameterName, value);
        if (value.isDefined() && !this.pattern.matcher(stringValue = value.asString()).matches()) {
            throw new OperationFailedException("Does not match pattern");
        }
    }
}

