/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.ManagementUtil;
import org.jboss.as.domain.management.security.SecurityRealmAddHandler;
import org.jboss.as.domain.management.security.SecurityRealmRemoveHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class SecurityRealmChildWriteAttributeHandler
extends RestartParentWriteAttributeHandler {
    private final AttributeDefinition[] attributeDefinitions;

    public SecurityRealmChildWriteAttributeHandler(AttributeDefinition ... attributes) {
        super("security-realm", attributes);
        this.attributeDefinitions = attributes;
    }

    void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attr : this.attributeDefinitions) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)this);
        }
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource resource) throws OperationFailedException {
        super.finishModelStage(context, operation, attributeName, newValue, oldValue, resource);
        if (attributeName.equals("credential-reference") || attributeName.equals("keystore-password-credential-reference") || attributeName.equals("key-password-credential-reference")) {
            CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)resource.getModel().get(attributeName), (String)attributeName);
        }
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<ModelNode> handbackHolder) throws OperationFailedException {
        boolean requiresReload = false;
        if (attributeName.equals("credential-reference") || attributeName.equals("keystore-password-credential-reference") || attributeName.equals("key-password-credential-reference")) {
            requiresReload = CredentialReference.applyCredentialReferenceUpdateToRuntime((OperationContext)context, (ModelNode)operation, (ModelNode)resolvedValue, (ModelNode)currentValue, (String)attributeName);
        }
        return super.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, handbackHolder) || requiresReload;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode resolvedValue, ModelNode invalidatedParentModel) throws OperationFailedException {
        if (attributeName.equals("credential-reference") || attributeName.equals("keystore-password-credential-reference") || attributeName.equals("key-password-credential-reference")) {
            CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)this.getAttributeDefinition(attributeName), (OperationContext)context, (ModelNode)resolvedValue);
        }
        super.revertUpdateToRuntime(context, operation, attributeName, valueToRestore, resolvedValue, invalidatedParentModel);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected boolean isResourceServiceRestartAllowed(OperationContext context, ServiceController<?> service) {
        return !ManagementUtil.isSecurityRealmReloadRequired(context, service);
    }

    protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
        SecurityRealmRemoveHandler.INSTANCE.removeServices(context, parentService.getSimpleName(), parentModel);
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
        SecurityRealmAddHandler.INSTANCE.installServices(context, parentAddress.getLastElement().getValue(), parentModel);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        String realmName = parentAddress.getLastElement().getValue();
        return SecurityRealm.ServiceUtil.createServiceName(realmName);
    }
}

