/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeSerializer;
import org.eclipse.yasson.internal.serializer.JsonbDateFormatter;

public abstract class AbstractDateTimeSerializer<T>
extends AbstractValueTypeSerializer<T> {
    public static final ZoneId UTC = ZoneId.of("UTC");

    public AbstractDateTimeSerializer(Customization customization) {
        super(customization);
    }

    @Override
    public void serialize(T obj, JsonGenerator generator, SerializationContext ctx) {
        JsonbContext jsonbContext = ((Marshaller)ctx).getJsonbContext();
        JsonbDateFormatter formatter = this.getJsonbDateFormatter(jsonbContext);
        generator.write(this.toJson(obj, formatter, jsonbContext));
    }

    public String toJson(T object, JsonbDateFormatter formatter, JsonbContext jsonbContext) {
        if ("##time-in-millis".equals(formatter.getFormat())) {
            return String.valueOf(this.toInstant(object).toEpochMilli());
        }
        if (formatter.getDateTimeFormatter() != null) {
            return this.formatWithFormatter(object, formatter.getDateTimeFormatter());
        }
        DateTimeFormatter configDateTimeFormatter = jsonbContext.getConfigProperties().getConfigDateFormatter().getDateTimeFormatter();
        if (configDateTimeFormatter != null) {
            return this.formatWithFormatter(object, configDateTimeFormatter);
        }
        if (jsonbContext.getConfigProperties().isStrictIJson()) {
            return this.formatStrictIJson(object);
        }
        return this.formatDefault(object, jsonbContext.getConfigProperties().getLocale(formatter.getLocale()));
    }

    protected JsonbDateFormatter getJsonbDateFormatter(JsonbContext context) {
        if (this.customization != null && this.customization.getSerializeDateFormatter() != null) {
            return this.customization.getSerializeDateFormatter();
        }
        return context.getConfigProperties().getConfigDateFormatter();
    }

    protected DateTimeFormatter getZonedFormatter(DateTimeFormatter formatter) {
        return formatter.getZone() != null ? formatter : formatter.withZone(UTC);
    }

    protected TemporalAccessor toTemporalAccessor(T object) {
        return (TemporalAccessor)object;
    }

    protected abstract Instant toInstant(T var1);

    protected abstract String formatDefault(T var1, Locale var2);

    protected String formatWithFormatter(T value, DateTimeFormatter formatter) {
        return formatter.format(this.toTemporalAccessor(value));
    }

    protected String formatStrictIJson(T value) {
        return JsonbDateFormatter.IJSON_DATE_FORMATTER.format(this.toTemporalAccessor(value));
    }

    @Override
    protected void serialize(T obj, JsonGenerator generator, Marshaller marshaller) {
        throw new UnsupportedOperationException("Not supported in DateTimeSerializer");
    }
}

