/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identity.plugins;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.RoleType;
import org.jboss.security.identity.plugins.SimpleRole;

public class SimpleRoleGroup
extends SimpleRole
implements RoleGroup {
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("roles", ArrayList.class)};
    private volatile HashSet<Role> roles = new HashSet();
    private static final String ROLES_IDENTIFIER = "Roles";

    public SimpleRoleGroup(String roleName) {
        super(roleName);
    }

    public SimpleRoleGroup(String roleName, Collection<Role> roles) {
        super(roleName);
        if (this.roles == null) {
            this.roles = new HashSet();
        }
        this.addAll(roles);
    }

    public SimpleRoleGroup(Group rolesGroup) {
        super(rolesGroup.getName());
        Enumeration principals = rolesGroup.members();
        while (principals.hasMoreElements()) {
            SimpleRole role = new SimpleRole(((Principal)principals.nextElement()).getName());
            this.addRole(role);
        }
    }

    public SimpleRoleGroup(Set<Principal> rolesAsPrincipals) {
        super(ROLES_IDENTIFIER);
        for (Principal p : rolesAsPrincipals) {
            SimpleRole role = new SimpleRole(p.getName());
            this.addRole(role);
        }
    }

    @Override
    public RoleType getType() {
        return RoleType.group;
    }

    @Override
    public synchronized void addRole(Role role) {
        this.roles.add(role);
    }

    @Override
    public synchronized void addAll(Collection<Role> roles) {
        if (roles != null) {
            this.roles.addAll(roles);
        }
    }

    @Override
    public synchronized void removeRole(Role role) {
        this.roles.remove(role);
    }

    @Override
    public synchronized void clearRoles() {
        this.roles.clear();
    }

    @Override
    public Collection<Role> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        SimpleRoleGroup clone = (SimpleRoleGroup)super.clone();
        if (clone != null) {
            clone.roles = (HashSet)this.roles.clone();
        }
        return clone;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField putFields = out.putFields();
        putFields.put("roles", new ArrayList<Role>(this.roles));
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = in.readFields();
        ArrayList fieldValue = (ArrayList)getField.get("roles", null);
        if (fieldValue instanceof ArrayList) {
            ArrayList stringList = fieldValue;
            this.roles = new HashSet(stringList);
        } else {
            this.roles = new HashSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Role anotherRole) {
        boolean isContained = false;
        if (anotherRole.getType() == RoleType.simple) {
            SimpleRoleGroup simpleRoleGroup = this;
            synchronized (simpleRoleGroup) {
                for (Role r : this.roles) {
                    isContained = r.containsAll(anotherRole);
                    if (!isContained) continue;
                    return true;
                }
            }
        } else {
            RoleGroup anotherRG = (RoleGroup)anotherRole;
            CopyOnWriteArrayList<Role> anotherRoles = new CopyOnWriteArrayList<Role>(anotherRG.getRoles());
            for (Role r : anotherRoles) {
                if (this.containsAll(r)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAtleastOneRole(RoleGroup anotherRole) {
        if (anotherRole == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("anotherRole");
        }
        CopyOnWriteArrayList<Role> roleList = new CopyOnWriteArrayList<Role>(anotherRole.getRoles());
        for (Role r : roleList) {
            if (!this.containsAll(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean containsRole(Role role) {
        for (Role r : this.roles) {
            if (!r.containsAll(role)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getRoleName());
        builder.append("(");
        SimpleRoleGroup simpleRoleGroup = this;
        synchronized (simpleRoleGroup) {
            for (Role role : this.roles) {
                builder.append(role.toString()).append(",");
            }
        }
        builder.append(")");
        return builder.toString();
    }
}

