/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io.logging;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.common.net.CidrAddress;
import org.wildfly.extension.io.logging.IOLogger;

public class IOLogger_$logger
extends DelegatingBasicLogger
implements IOLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = IOLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public IOLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void printDefaults(String workerName, int ioThreads, int workerThreads, int cpuCount) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.printDefaults$str(), new Object[]{workerName, ioThreads, workerThreads, cpuCount});
    }

    protected String printDefaults$str() {
        return "WFLYIO001: Worker '%s' has auto-configured to %d IO threads with %d max task threads based on your %d available processors";
    }

    @Override
    public final void printDefaultsIoThreads(String workerName, int ioThreads, int cpuCount) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.printDefaultsIoThreads$str(), (Object)workerName, (Object)ioThreads, (Object)cpuCount);
    }

    protected String printDefaultsIoThreads$str() {
        return "WFLYIO002: Worker '%s' has auto-configured to %d IO threads based on your %d available processors";
    }

    @Override
    public final void printDefaultsWorkerThreads(String workerName, int workerThreads, int cpuCount) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.printDefaultsWorkerThreads$str(), (Object)workerName, (Object)workerThreads, (Object)cpuCount);
    }

    protected String printDefaultsWorkerThreads$str() {
        return "WFLYIO003: Worker '%s' has auto-configured to %d max task threads based on your %d available processors";
    }

    @Override
    public final void lowFD(String workerName, int suggestedWorkerThreadCount, int cpuCount) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.lowFD$str(), (Object)workerName, (Object)suggestedWorkerThreadCount, (Object)cpuCount);
    }

    protected String lowFD$str() {
        return "WFLYIO004: Worker '%s' would auto-configure to %d max task threads based on %d available processors, however your system does not have enough file descriptors configured to support this configuration. It is likely you will experience application degradation unless you increase your file descriptor limit.";
    }

    @Override
    public final void lowGlobalFD(int maxFd, int requiredCount) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.lowGlobalFD$str(), (Object)maxFd, (Object)requiredCount);
    }

    protected String lowGlobalFD$str() {
        return "WFLYIO005: Your system is configured with %d file descriptors, but your current application server configuration will require a minimum of %d (and probably more than that); attempting to adjust, however you should expect stability problems unless you increase this number";
    }

    protected String noMetrics$str() {
        return "WFLYIO006: no metrics available";
    }

    @Override
    public final String noMetrics() {
        return String.format(this.getLoggingLocale(), this.noMetrics$str(), new Object[0]);
    }

    protected String unexpectedBindAddressConflict$str() {
        return "WFLYIO007: Unexpected bind address conflict in resource \"%s\" when attempting to establish binding for destination %s to %s: a binding of %s already existed";
    }

    @Override
    public final OperationFailedException unexpectedBindAddressConflict(PathAddress currentAddress, CidrAddress cidrAddress, InetSocketAddress bindAddress, InetSocketAddress existing) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unexpectedBindAddressConflict$str(), currentAddress, cidrAddress, bindAddress, existing));
        IOLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
}

