/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.encryption;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.wildfly.common.Assert;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.encryption.Common;
import org.wildfly.security.encryption.ElytronMessages;

public class SecretKeyUtil {
    private static final String SECRET_KEY_ALGORITHM = "AES";

    public static SecretKey generateSecretKey(int keySize) throws GeneralSecurityException {
        SecretKeyUtil.checkKeySize(keySize);
        SecureRandom random = new SecureRandom();
        byte[] rawKey = new byte[keySize / 8];
        random.nextBytes(rawKey);
        SecretKeySpec secretKey = new SecretKeySpec(rawKey, SECRET_KEY_ALGORITHM);
        Arrays.fill(rawKey, (byte)0);
        return secretKey;
    }

    public static String exportSecretKey(SecretKey secretKey) throws GeneralSecurityException {
        Assert.checkNotNullParam("secretKey", secretKey);
        byte[] key = secretKey.getEncoded();
        SecretKeyUtil.checkKeySize(key.length * 8);
        byte[] result = new byte[key.length + 5];
        result[0] = 69;
        result[1] = 76;
        result[2] = 89;
        result[3] = 1;
        result[4] = 75;
        System.arraycopy(key, 0, result, 5, key.length);
        return ByteIterator.ofBytes(result).base64Encode().drainToString();
    }

    public static SecretKey importSecretKey(char[] rawData, int offset, int length) throws GeneralSecurityException {
        return SecretKeyUtil.importSecretKey(CodePointIterator.ofChars(Assert.checkNotNullParam("rawData", rawData), offset, length));
    }

    public static SecretKey importSecretKey(String secretKey) throws GeneralSecurityException {
        return SecretKeyUtil.importSecretKey(CodePointIterator.ofString(Assert.checkNotNullParam("secretKey", secretKey)));
    }

    private static SecretKey importSecretKey(CodePointIterator codePointIterator) throws GeneralSecurityException {
        ByteIterator byteIterator = codePointIterator.base64Decode();
        byte[] prefixVersion = byteIterator.drain(5);
        if (prefixVersion.length < 4 || prefixVersion[0] != 69 || prefixVersion[1] != 76 || prefixVersion[2] != 89) {
            throw ElytronMessages.log.badKeyPrefix();
        }
        if (prefixVersion[3] != 1) {
            throw ElytronMessages.log.unsupportedVersion(prefixVersion[3], 1);
        }
        if (prefixVersion[4] != 75) {
            throw ElytronMessages.log.unexpectedTokenType(Common.toName((char)prefixVersion[4]), "SecretKey");
        }
        byte[] key = byteIterator.drain();
        SecretKeyUtil.checkKeySize(key.length * 8);
        return new SecretKeySpec(key, SECRET_KEY_ALGORITHM);
    }

    private static void checkKeySize(int keySize) throws GeneralSecurityException {
        if (keySize != 128 && keySize != 192 && keySize != 256) {
            throw ElytronMessages.log.badKeySize();
        }
    }
}

