/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ConfiguredDomains {
    private final String legacyDomain;
    private final String exprDomain;

    public ConfiguredDomains(String legacyDomain, String exprDomain) {
        assert (legacyDomain != null || exprDomain != null);
        this.legacyDomain = legacyDomain;
        this.exprDomain = exprDomain;
    }

    String[] getDomains() {
        if (this.legacyDomain != null && this.exprDomain != null) {
            return new String[]{this.legacyDomain, this.exprDomain};
        }
        if (this.legacyDomain != null) {
            return new String[]{this.legacyDomain};
        }
        if (this.exprDomain != null) {
            return new String[]{this.exprDomain};
        }
        return new String[0];
    }

    ObjectName getMirroredObjectName(ObjectName name) {
        String domain = name.getDomain();
        String mirroredDomain = null;
        if (domain.equals(this.legacyDomain)) {
            mirroredDomain = this.exprDomain;
        } else if (domain.equals(this.exprDomain)) {
            mirroredDomain = this.legacyDomain;
        }
        if (mirroredDomain == null) {
            return null;
        }
        try {
            return new ObjectName(mirroredDomain, name.getKeyPropertyList());
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    boolean isLegacyDomain(ObjectName name) {
        return name.getDomain().equals(this.legacyDomain);
    }

    String getLegacyDomain() {
        return this.legacyDomain;
    }

    String getExprDomain() {
        return this.exprDomain;
    }
}

