/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2021, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;

import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamWriter;

/**
 * A {@link RawProtoStreamWriter} with the additional ability to write an arbitrary embedded object.
 * @author Paul Ferraro
 */
public interface ProtoStreamWriter extends RawProtoStreamWriter {

    ImmutableSerializationContext getSerializationContext();

    void writeObject(int index, Object value) throws IOException;

    void writeObjectNoTag(Object value) throws IOException;

    <E extends Enum<E>> void writeEnum(int index, E value) throws IOException;

    void writeBoolNoTag(boolean value) throws IOException;

    void writeSInt32NoTag(int value) throws IOException;

    void writeSInt64NoTag(long value) throws IOException;

    void writeFloatNoTag(float value) throws IOException;

    void writeDoubleNoTag(double value) throws IOException;

    void writeStringNoTag(String value) throws IOException;

    void writeRawByte(byte value) throws IOException;
}
