/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.json.JsonStructure;
import javax.json.bind.JsonbConfig;
import javax.json.bind.JsonbException;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.YassonJsonb;
import org.eclipse.yasson.internal.JsonBindingBuilder;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.JsonbRiParser;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.jsonstructure.JsonGeneratorToStructureAdapter;
import org.eclipse.yasson.internal.jsonstructure.JsonStructureToParserAdapter;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

public class JsonBinding
implements YassonJsonb {
    private final JsonbContext jsonbContext;

    JsonBinding(JsonBindingBuilder builder) {
        this.jsonbContext = new JsonbContext(builder.getConfig(), builder.getProvider().orElseGet(JsonProvider::provider));
    }

    private <T> T deserialize(Type type, JsonParser parser, Unmarshaller unmarshaller) {
        return unmarshaller.deserialize(type, parser);
    }

    public <T> T fromJson(String str, Class<T> type) throws JsonbException {
        JsonbRiParser parser = new JsonbRiParser(this.jsonbContext.getJsonProvider().createParser((Reader)new StringReader(str)));
        Unmarshaller unmarshaller = new Unmarshaller(this.jsonbContext);
        return this.deserialize(type, parser, unmarshaller);
    }

    public <T> T fromJson(String str, Type type) throws JsonbException {
        JsonbRiParser parser = new JsonbRiParser(this.jsonbContext.getJsonProvider().createParser((Reader)new StringReader(str)));
        Unmarshaller unmarshaller = new Unmarshaller(this.jsonbContext);
        return this.deserialize(type, parser, unmarshaller);
    }

    public <T> T fromJson(Reader reader, Class<T> type) throws JsonbException {
        JsonbRiParser parser = new JsonbRiParser(this.jsonbContext.getJsonProvider().createParser(reader));
        Unmarshaller unmarshaller = new Unmarshaller(this.jsonbContext);
        return this.deserialize(type, parser, unmarshaller);
    }

    public <T> T fromJson(Reader reader, Type type) throws JsonbException {
        JsonbRiParser parser = new JsonbRiParser(this.jsonbContext.getJsonProvider().createParser(reader));
        Unmarshaller unmarshaller = new Unmarshaller(this.jsonbContext);
        return this.deserialize(type, parser, unmarshaller);
    }

    public <T> T fromJson(InputStream stream, Class<T> clazz) throws JsonbException {
        Unmarshaller unmarshaller = new Unmarshaller(this.jsonbContext);
        return this.deserialize(clazz, this.inputStreamParser(stream), unmarshaller);
    }

    public <T> T fromJson(InputStream stream, Type type) throws JsonbException {
        Unmarshaller unmarshaller = new Unmarshaller(this.jsonbContext);
        return this.deserialize(type, this.inputStreamParser(stream), unmarshaller);
    }

    @Override
    public <T> T fromJsonStructure(JsonStructure jsonStructure, Class<T> type) throws JsonbException {
        JsonbRiParser parser = new JsonbRiParser(new JsonStructureToParserAdapter(jsonStructure));
        return this.deserialize(type, parser, new Unmarshaller(this.jsonbContext));
    }

    @Override
    public <T> T fromJsonStructure(JsonStructure jsonStructure, Type runtimeType) throws JsonbException {
        JsonbRiParser parser = new JsonbRiParser(new JsonStructureToParserAdapter(jsonStructure));
        return this.deserialize(runtimeType, parser, new Unmarshaller(this.jsonbContext));
    }

    private JsonParser inputStreamParser(InputStream stream) {
        return new JsonbRiParser(this.jsonbContext.getJsonProvider().createParserFactory(this.createJsonpProperties(this.jsonbContext.getConfig())).createParser(stream, Charset.forName(this.jsonbContext.getConfig().getProperty("jsonb.encoding").orElse("UTF-8"))));
    }

    public String toJson(Object object) throws JsonbException {
        StringWriter writer = new StringWriter();
        JsonGenerator generator = this.writerGenerator(writer);
        new Marshaller(this.jsonbContext).marshall(object, generator);
        return writer.toString();
    }

    public String toJson(Object object, Type type) throws JsonbException {
        StringWriter writer = new StringWriter();
        JsonGenerator generator = this.writerGenerator(writer);
        new Marshaller(this.jsonbContext, type).marshall(object, generator);
        return writer.toString();
    }

    public void toJson(Object object, Writer writer) throws JsonbException {
        Marshaller marshaller = new Marshaller(this.jsonbContext);
        marshaller.marshall(object, this.writerGenerator(writer));
    }

    public void toJson(Object object, Type type, Writer writer) throws JsonbException {
        Marshaller marshaller = new Marshaller(this.jsonbContext, type);
        marshaller.marshall(object, this.writerGenerator(writer));
    }

    private JsonGenerator writerGenerator(Writer writer) {
        Map<String, ?> factoryProperties = this.createJsonpProperties(this.jsonbContext.getConfig());
        if (factoryProperties.isEmpty()) {
            return this.jsonbContext.getJsonProvider().createGenerator(writer);
        }
        return this.jsonbContext.getJsonProvider().createGeneratorFactory(factoryProperties).createGenerator(writer);
    }

    public void toJson(Object object, OutputStream stream) throws JsonbException {
        Marshaller marshaller = new Marshaller(this.jsonbContext);
        marshaller.marshall(object, this.streamGenerator(stream));
    }

    public void toJson(Object object, Type type, OutputStream stream) throws JsonbException {
        Marshaller marshaller = new Marshaller(this.jsonbContext, type);
        marshaller.marshall(object, this.streamGenerator(stream));
    }

    @Override
    public <T> T fromJson(JsonParser jsonParser, Class<T> type) throws JsonbException {
        Unmarshaller unmarshaller = new Unmarshaller(this.jsonbContext);
        return unmarshaller.deserialize(type, (JsonParser)new JsonbRiParser(jsonParser));
    }

    @Override
    public <T> T fromJson(JsonParser jsonParser, Type runtimeType) throws JsonbException {
        Unmarshaller unmarshaller = new Unmarshaller(this.jsonbContext);
        return unmarshaller.deserialize(runtimeType, (JsonParser)new JsonbRiParser(jsonParser));
    }

    @Override
    public void toJson(Object object, JsonGenerator jsonGenerator) throws JsonbException {
        Marshaller marshaller = new Marshaller(this.jsonbContext);
        marshaller.marshallWithoutClose(object, jsonGenerator);
    }

    @Override
    public void toJson(Object object, Type runtimeType, JsonGenerator jsonGenerator) throws JsonbException {
        Marshaller marshaller = new Marshaller(this.jsonbContext, runtimeType);
        marshaller.marshallWithoutClose(object, jsonGenerator);
    }

    @Override
    public JsonStructure toJsonStructure(Object object) throws JsonbException {
        JsonGeneratorToStructureAdapter structureGenerator = new JsonGeneratorToStructureAdapter(this.jsonbContext.getJsonProvider());
        Marshaller marshaller = new Marshaller(this.jsonbContext);
        marshaller.marshall(object, structureGenerator);
        return structureGenerator.getRootStructure();
    }

    @Override
    public JsonStructure toJsonStructure(Object object, Type runtimeType) throws JsonbException {
        JsonGeneratorToStructureAdapter structureGenerator = new JsonGeneratorToStructureAdapter(this.jsonbContext.getJsonProvider());
        Marshaller marshaller = new Marshaller(this.jsonbContext, runtimeType);
        marshaller.marshall(object, structureGenerator);
        return structureGenerator.getRootStructure();
    }

    private JsonGenerator streamGenerator(OutputStream stream) {
        Map<String, ?> factoryProperties = this.createJsonpProperties(this.jsonbContext.getConfig());
        String encoding = this.jsonbContext.getConfig().getProperty("jsonb.encoding").orElse("UTF-8");
        return this.jsonbContext.getJsonProvider().createGeneratorFactory(factoryProperties).createGenerator(stream, Charset.forName(encoding));
    }

    public void close() throws Exception {
        this.jsonbContext.getComponentInstanceCreator().close();
    }

    protected Map<String, ?> createJsonpProperties(JsonbConfig jsonbConfig) {
        Optional property = jsonbConfig.getProperty("jsonb.formatting");
        HashMap<String, Boolean> factoryProperties = new HashMap<String, Boolean>();
        if (property.isPresent()) {
            Object value = property.get();
            if (!(value instanceof Boolean)) {
                throw new JsonbException(Messages.getMessage(MessageKeys.JSONB_CONFIG_FORMATTING_ILLEGAL_VALUE, new Object[0]));
            }
            if (((Boolean)value).booleanValue()) {
                factoryProperties.put("javax.json.stream.JsonGenerator.prettyPrinting", Boolean.TRUE);
            }
            return factoryProperties;
        }
        return factoryProperties;
    }
}

