/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.domain;

import java.io.Serializable;
import org.jboss.as.controller.client.logging.ControllerClientLogger;
import org.wildfly.common.Assert;

public class ServerGroupDeploymentPlan
implements Serializable {
    private static final long serialVersionUID = 4868990805217024722L;
    private final String serverGroupName;
    private final boolean rollback;
    private final boolean rollingToServers;
    private final int maxFailures;
    private final int maxFailurePercentage;

    public ServerGroupDeploymentPlan(String serverGroupName) {
        this(serverGroupName, false, false, 0, 0);
    }

    private ServerGroupDeploymentPlan(String serverGroupName, boolean rollback, boolean rollingToServers, int maxFailures, int maxFailurePercentage) {
        Assert.checkNotNullParam((String)"serverGroupName", (Object)serverGroupName);
        this.serverGroupName = serverGroupName;
        this.rollback = rollback;
        this.rollingToServers = rollingToServers;
        this.maxFailures = maxFailures;
        this.maxFailurePercentage = maxFailurePercentage;
    }

    public String getServerGroupName() {
        return this.serverGroupName;
    }

    public boolean isRollback() {
        return this.rollback;
    }

    public boolean isRollingToServers() {
        return this.rollingToServers;
    }

    public int getMaxServerFailures() {
        return this.maxFailures;
    }

    public int getMaxServerFailurePercentage() {
        return this.maxFailurePercentage;
    }

    public boolean equals(Object obj) {
        return obj instanceof ServerGroupDeploymentPlan && ((ServerGroupDeploymentPlan)obj).serverGroupName.equals(this.serverGroupName);
    }

    public int hashCode() {
        return this.serverGroupName.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{serverGroupName=" + this.serverGroupName + ",rollback=" + this.rollback + ",rollingToServers=" + this.rollingToServers + "}";
    }

    public ServerGroupDeploymentPlan createRollback() {
        return new ServerGroupDeploymentPlan(this.serverGroupName, true, this.rollingToServers, this.maxFailures, this.maxFailurePercentage);
    }

    public ServerGroupDeploymentPlan createRollingToServers() {
        return new ServerGroupDeploymentPlan(this.serverGroupName, this.rollback, true, this.maxFailures, this.maxFailurePercentage);
    }

    public ServerGroupDeploymentPlan createAllowFailures(int serverFailures) {
        if (serverFailures < 1) {
            throw ControllerClientLogger.ROOT_LOGGER.invalidValue("serverFailures", serverFailures, 0);
        }
        return new ServerGroupDeploymentPlan(this.serverGroupName, true, this.rollingToServers, serverFailures, this.maxFailurePercentage);
    }

    public ServerGroupDeploymentPlan createAllowFailurePercentage(int serverFailurePercentage) {
        if (serverFailurePercentage < 1 || serverFailurePercentage > 99) {
            throw ControllerClientLogger.ROOT_LOGGER.invalidValue("serverFailurePercentage", serverFailurePercentage, 0, 100);
        }
        return new ServerGroupDeploymentPlan(this.serverGroupName, true, this.rollingToServers, this.maxFailures, serverFailurePercentage);
    }
}

