/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import org.wildfly.openssl.Messages;
import org.wildfly.openssl.OpenSSLEngine;
import org.wildfly.openssl.OpenSSLSessionContext;
import org.wildfly.openssl.OpenSslX509Certificate;
import org.wildfly.openssl.SSL;

class OpenSSlSession
implements SSLSession {
    public static final String NULL_CIPHER = "TLS_NULL_WITH_NULL_NULL";
    private final boolean server;
    private final OpenSSLSessionContext sessionContext;
    private static final Certificate[] EMPTY_CERTIFICATES = new Certificate[0];
    private volatile javax.security.cert.X509Certificate[] x509PeerCerts;
    private volatile Certificate[] peerCerts;
    private Map<String, Object> values;
    private volatile long creationTime;
    private volatile byte[] sessionId;
    private volatile long sessionPointer;
    private volatile boolean valid = true;
    private String cipherSuite = "SSL_NULL_WITH_NULL_NULL";
    private String protocol = "TLS";
    private boolean reused;

    OpenSSlSession(boolean server, OpenSSLSessionContext sessionContext) {
        this.server = server;
        this.sessionContext = sessionContext;
    }

    @Override
    public byte[] getId() {
        return this.sessionId;
    }

    @Override
    public SSLSessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.getCreationTime();
    }

    @Override
    public synchronized void invalidate() {
        if (this.valid) {
            if (this.sessionPointer > 0L) {
                SSL.getInstance().invalidateSession(this.sessionPointer);
            }
            this.sessionContext.remove(this.sessionId);
            this.sessionPointer = 0L;
            this.valid = false;
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public synchronized void putValue(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.nameWasNull());
        }
        if (value == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.valueWasNull());
        }
        Map<String, Object> values = this.values;
        if (values == null) {
            values = this.values = new HashMap<String, Object>(2);
        }
        Object old = values.put(name, value);
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
        this.notifyUnbound(old, name);
    }

    @Override
    public synchronized Object getValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.nameWasNull());
        }
        if (this.values == null) {
            return null;
        }
        return this.values.get(name);
    }

    @Override
    public synchronized void removeValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.nameWasNull());
        }
        Map<String, Object> values = this.values;
        if (values == null) {
            return;
        }
        Object old = values.remove(name);
        this.notifyUnbound(old, name);
    }

    @Override
    public synchronized String[] getValueNames() {
        Map<String, Object> values = this.values;
        if (values == null || values.isEmpty()) {
            return new String[0];
        }
        return values.keySet().toArray(new String[values.size()]);
    }

    private void notifyUnbound(Object value, String name) {
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException(Messages.MESSAGES.unverifiedPeer());
        }
        return this.peerCerts;
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return EMPTY_CERTIFICATES;
    }

    @Override
    public javax.security.cert.X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.x509PeerCerts == null) {
            throw new SSLPeerUnverifiedException(Messages.MESSAGES.unverifiedPeer());
        }
        return this.x509PeerCerts;
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        Certificate[] peer = this.getPeerCertificates();
        if (peer == null || peer.length == 0) {
            return null;
        }
        return this.firstCertificate(peer).getSubjectX500Principal();
    }

    @Override
    public Principal getLocalPrincipal() {
        Certificate[] local = this.getLocalCertificates();
        if (local == null || local.length == 0) {
            return null;
        }
        return this.firstCertificate(local).getSubjectX500Principal();
    }

    private X509Certificate firstCertificate(Certificate[] certs) {
        return (X509Certificate)certs[0];
    }

    @Override
    public String getCipherSuite() {
        if (this.cipherSuite == null) {
            return NULL_CIPHER;
        }
        return this.cipherSuite;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getPeerHost() {
        return null;
    }

    @Override
    public int getPeerPort() {
        return 0;
    }

    @Override
    public int getPacketBufferSize() {
        return 18713;
    }

    @Override
    public int getApplicationBufferSize() {
        return 16384;
    }

    boolean isReused() {
        return this.reused;
    }

    private void initPeerCertChain(long ssl) {
        Certificate[] peerCerts;
        byte[][] chain = SSL.getInstance().getPeerCertChain(ssl);
        byte[] clientCert = this.server ? SSL.getInstance().getPeerCertificate(ssl) : null;
        if (chain == null && clientCert == null) {
            this.peerCerts = null;
            return;
        }
        int len = 0;
        if (chain != null) {
            len += chain.length;
        }
        int i = 0;
        if (clientCert != null) {
            peerCerts = new Certificate[++len];
            peerCerts[i++] = new OpenSslX509Certificate(clientCert);
        } else {
            peerCerts = new Certificate[len];
        }
        if (chain != null) {
            int a = 0;
            while (i < peerCerts.length) {
                peerCerts[i] = new OpenSslX509Certificate(chain[a++]);
                ++i;
            }
        }
        this.peerCerts = peerCerts;
        javax.security.cert.X509Certificate[] x509Certificates = new javax.security.cert.X509Certificate[peerCerts.length];
        for (int j = 0; j < x509Certificates.length; ++j) {
            try {
                x509Certificates[j] = javax.security.cert.X509Certificate.getInstance(peerCerts[j].getEncoded());
                continue;
            }
            catch (CertificateEncodingException | CertificateException e) {
                throw new IllegalStateException(e);
            }
        }
        this.x509PeerCerts = x509Certificates;
    }

    void initialised(long pointer, long ssl, byte[] sessionId) {
        this.sessionPointer = pointer;
        this.sessionId = sessionId;
        this.initCreationTime(ssl);
        this.initPeerCertChain(ssl);
        this.initCipherSuite(ssl);
        this.initProtocol(ssl);
        this.initReused(ssl);
    }

    void initialised(long ssl) {
        this.initCreationTime(ssl);
        this.initSessionId(ssl);
        this.initPeerCertChain(ssl);
        this.initCipherSuite(ssl);
        this.initProtocol(ssl);
        this.initReused(ssl);
    }

    private void initSessionId(long ssl) {
        this.sessionId = SSL.getInstance().getSessionId(ssl);
    }

    private void initProtocol(long ssl) {
        this.protocol = SSL.getInstance().getVersion(ssl);
    }

    private void initCipherSuite(long ssl) {
        String c = OpenSSLEngine.toJavaCipherSuite(SSL.getInstance().getCipherForSSL(ssl), ssl);
        if (c != null) {
            this.cipherSuite = c;
        }
    }

    private void initCreationTime(long ssl) {
        this.creationTime = SSL.getInstance().getTime(ssl) * 1000L;
    }

    private void initReused(long ssl) {
        this.reused = OpenSSLEngine.isOpenSSL10() ? false : SSL.getInstance().getSSLSessionReused(ssl);
    }
}

