/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.parsing;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.parsing.WriteUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class InterfacesXml {
    InterfacesXml() {
    }

    public void parseInterfaces(XMLExtendedStreamReader reader, Set<String> names, ModelNode address, Namespace expectedNs, List<ModelNode> list, boolean checkSpecified) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (Element.INTERFACE != element) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
            String name = reader.getAttributeValue(0);
            if (!names.add(name)) {
                throw ControllerLogger.ROOT_LOGGER.duplicateInterfaceDeclaration(reader.getLocation());
            }
            ModelNode interfaceAdd = new ModelNode();
            interfaceAdd.get("address").set(address).add("interface", name);
            interfaceAdd.get("operation").set("add");
            ModelNode criteriaNode = interfaceAdd;
            this.parseInterfaceCriteria(reader, expectedNs, interfaceAdd);
            if (checkSpecified && criteriaNode.getType() != ModelType.STRING && criteriaNode.getType() != ModelType.EXPRESSION && criteriaNode.asInt() == 0) {
                throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
            }
            list.add(interfaceAdd);
        }
    }

    private void parseInterfaceCriteria(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode interfaceModel) throws XMLStreamException {
        if (reader.nextTag() == 2) {
            return;
        }
        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        Element element = Element.forName((String)reader.getLocalName());
        switch (element) {
            case ANY_IPV4_ADDRESS: 
            case ANY_IPV6_ADDRESS: {
                if (expectedNs.getMajorVersion() >= 3) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                throw ParseUtils.unsupportedElement((XMLExtendedStreamReader)reader, (String)Element.ANY_ADDRESS.getLocalName());
            }
            case ANY_ADDRESS: {
                interfaceModel.get(Element.ANY_ADDRESS.getLocalName()).set(true);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                return;
            }
        }
        do {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ANY: {
                    this.parseCompoundInterfaceCriterion(reader, expectedNs, interfaceModel.get("any").setEmptyObject());
                    break;
                }
                case NOT: {
                    this.parseCompoundInterfaceCriterion(reader, expectedNs, interfaceModel.get("not").setEmptyObject());
                    break;
                }
                default: {
                    this.parseSimpleInterfaceCriterion(reader, interfaceModel, false);
                }
            }
        } while (reader.nextTag() != 2);
    }

    private void parseCompoundInterfaceCriterion(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode subModel) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            this.parseSimpleInterfaceCriterion(reader, subModel, true);
        }
    }

    private void parseSimpleInterfaceCriterion(XMLExtendedStreamReader reader, ModelNode subModel, boolean nested) throws XMLStreamException {
        Element element = Element.forName((String)reader.getLocalName());
        String localName = element.getLocalName();
        switch (element) {
            case INET_ADDRESS: {
                ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
                String value = reader.getAttributeValue(0);
                ModelNode valueNode = ParseUtils.parsePossibleExpression((String)value);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                if (nested) {
                    subModel.get(localName).add(valueNode);
                    break;
                }
                subModel.get(localName).set(valueNode);
                break;
            }
            case LOOPBACK_ADDRESS: {
                ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
                String value = reader.getAttributeValue(0);
                ModelNode valueNode = ParseUtils.parsePossibleExpression((String)value);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                subModel.get(localName).set(valueNode);
                break;
            }
            case LINK_LOCAL_ADDRESS: 
            case LOOPBACK: 
            case MULTICAST: 
            case POINT_TO_POINT: 
            case PUBLIC_ADDRESS: 
            case SITE_LOCAL_ADDRESS: 
            case UP: 
            case VIRTUAL: {
                ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                subModel.get(localName).set(true);
                break;
            }
            case NIC: {
                ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                if (nested) {
                    subModel.get(localName).add(value);
                    break;
                }
                subModel.get(localName).set(value);
                break;
            }
            case NIC_MATCH: {
                ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.PATTERN.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                if (nested) {
                    subModel.get(localName).add(value);
                    break;
                }
                subModel.get(localName).set(value);
                break;
            }
            case SUBNET_MATCH: {
                ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                if (nested) {
                    subModel.get(localName).add(value);
                    break;
                }
                subModel.get(localName).set(value);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    void writeInterfaces(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        writer.writeStartElement(Element.INTERFACES.getLocalName());
        TreeSet interfaces = new TreeSet(modelNode.keys());
        for (String ifaceName : interfaces) {
            ModelNode iface = modelNode.get(ifaceName);
            writer.writeStartElement(Element.INTERFACE.getLocalName());
            WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)ifaceName);
            if (iface.get(Element.ANY_ADDRESS.getLocalName()).asBoolean(false)) {
                writer.writeEmptyElement(Element.ANY_ADDRESS.getLocalName());
            } else {
                this.writeInterfaceCriteria(writer, iface, false);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeInterfaceCriteria(XMLExtendedStreamWriter writer, ModelNode subModel, boolean nested) throws XMLStreamException {
        for (Property property : subModel.asPropertyList()) {
            if (!property.getValue().isDefined()) continue;
            this.writeInterfaceCriteria(writer, property, nested);
        }
    }

    private void writeInterfaceCriteria(XMLExtendedStreamWriter writer, Property property, boolean nested) throws XMLStreamException {
        Element element = Element.forName((String)property.getName());
        switch (element) {
            case INET_ADDRESS: {
                InterfacesXml.writeInterfaceCriteria(writer, element, Attribute.VALUE, property.getValue(), nested);
                break;
            }
            case LOOPBACK_ADDRESS: {
                InterfacesXml.writeInterfaceCriteria(writer, element, Attribute.VALUE, property.getValue(), false);
                break;
            }
            case LINK_LOCAL_ADDRESS: 
            case LOOPBACK: 
            case MULTICAST: 
            case POINT_TO_POINT: 
            case PUBLIC_ADDRESS: 
            case SITE_LOCAL_ADDRESS: 
            case UP: 
            case VIRTUAL: {
                if (!property.getValue().asBoolean(false)) break;
                writer.writeEmptyElement(element.getLocalName());
                break;
            }
            case NIC: {
                InterfacesXml.writeInterfaceCriteria(writer, element, Attribute.NAME, property.getValue(), nested);
                break;
            }
            case NIC_MATCH: {
                InterfacesXml.writeInterfaceCriteria(writer, element, Attribute.PATTERN, property.getValue(), nested);
                break;
            }
            case SUBNET_MATCH: {
                InterfacesXml.writeInterfaceCriteria(writer, element, Attribute.VALUE, property.getValue(), nested);
                break;
            }
            case ANY: 
            case NOT: {
                if (nested) break;
                writer.writeStartElement(element.getLocalName());
                this.writeInterfaceCriteria(writer, property.getValue(), true);
                writer.writeEndElement();
                break;
            }
            case NAME: {
                break;
            }
            case ANY_ADDRESS: {
                assert (!property.getValue().asBoolean(false));
                break;
            }
            default: {
                throw ControllerLogger.ROOT_LOGGER.unknownCriteriaInterfaceProperty(property.getName());
            }
        }
    }

    private static void writeInterfaceCriteria(XMLExtendedStreamWriter writer, Element element, Attribute attribute, ModelNode subModel, boolean asList) throws XMLStreamException {
        if (asList) {
            WriteUtils.writeListAsMultipleElements((XMLExtendedStreamWriter)writer, (Element)element, (Attribute)attribute, (ModelNode)subModel);
        } else {
            WriteUtils.writeSingleElement((XMLExtendedStreamWriter)writer, (Element)element, (Attribute)attribute, (ModelNode)subModel);
        }
    }
}

