/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.callback;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.auth.callback.ObjectCallback;
import org.jboss.security.auth.callback.SecurityActions;
import org.jboss.security.auth.callback.SecurityAssociationCallback;

public class SecurityAssociationHandler
implements CallbackHandler {
    private Principal principal;
    private Object credential;

    public SecurityAssociationHandler() {
    }

    public SecurityAssociationHandler(Principal principal, Object credential) {
        this.principal = principal;
        this.credential = credential;
    }

    public void setSecurityInfo(Principal principal, Object credential) {
        this.principal = principal;
        this.credential = credential;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException, IOException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback c = callbacks[i];
            if (c instanceof SecurityAssociationCallback) {
                SecurityAssociationCallback sac = (SecurityAssociationCallback)c;
                sac.setPrincipal(this.principal);
                sac.setCredential(this.credential);
                continue;
            }
            if (c instanceof ObjectCallback) {
                ObjectCallback oc = (ObjectCallback)c;
                oc.setCredential(this.credential);
                continue;
            }
            if (c instanceof NameCallback) {
                NameCallback nc = (NameCallback)c;
                if (this.principal == null) continue;
                nc.setName(this.principal.getName());
                continue;
            }
            if (c instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)c;
                char[] password = this.getPassword();
                if (password == null) continue;
                pc.setPassword(password);
                continue;
            }
            try {
                CallbackHandler handler = SecurityActions.getContextCallbackHandler();
                if (handler != null) {
                    Callback[] unknown = new Callback[]{c};
                    handler.handle(unknown);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw PicketBoxMessages.MESSAGES.unableToHandleCallback(c, this.getClass().getName(), c.getClass().getCanonicalName());
        }
    }

    private char[] getPassword() {
        char[] password;
        block6: {
            password = null;
            if (this.credential instanceof char[]) {
                password = (char[])this.credential;
            } else if (this.credential instanceof String) {
                String s = (String)this.credential;
                password = s.toCharArray();
            } else {
                try {
                    Class[] types = new Class[]{};
                    Method m = this.credential.getClass().getMethod("toCharArray", types);
                    Object[] args = new Object[]{};
                    password = (char[])m.invoke(this.credential, args);
                }
                catch (Exception e) {
                    if (this.credential == null) break block6;
                    String s = this.credential.toString();
                    password = s.toCharArray();
                }
            }
        }
        return password;
    }
}

