/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.keyprovider.HostKeyCertificateProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.ServerAuthenticationManager;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.UserAuthFactory;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.session.ServerConnectionServiceFactory;
import org.apache.sshd.server.session.ServerProxyAcceptor;
import org.apache.sshd.server.session.ServerUserAuthServiceFactory;
import org.apache.sshd.server.session.SessionFactory;
import org.apache.sshd.server.shell.ShellFactory;
import org.apache.sshd.server.subsystem.SubsystemFactory;

public class SshServer
extends AbstractFactoryManager
implements ServerFactoryManager,
Closeable {
    public static final Factory<SshServer> DEFAULT_SSH_SERVER_FACTORY = SshServer::new;
    public static final List<ServiceFactory> DEFAULT_SERVICE_FACTORIES = Collections.unmodifiableList(Arrays.asList(ServerUserAuthServiceFactory.INSTANCE, ServerConnectionServiceFactory.INSTANCE));
    protected IoAcceptor acceptor;
    protected String host;
    protected int port;
    private ServerProxyAcceptor proxyAcceptor;
    private ShellFactory shellFactory;
    private SessionFactory sessionFactory;
    private CommandFactory commandFactory;
    private List<SubsystemFactory> subsystemFactories;
    private List<UserAuthFactory> userAuthFactories;
    private KeyPairProvider keyPairProvider;
    private HostKeyCertificateProvider hostKeyCertificateProvider;
    private PasswordAuthenticator passwordAuthenticator;
    private PublickeyAuthenticator publickeyAuthenticator;
    private KeyboardInteractiveAuthenticator interactiveAuthenticator;
    private HostBasedAuthenticator hostBasedAuthenticator;
    private GSSAuthenticator gssAuthenticator;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Set<SocketAddress> getBoundAddresses() {
        return this.acceptor == null ? Collections.emptySet() : this.acceptor.getBoundAddresses();
    }

    public List<UserAuthFactory> getUserAuthFactories() {
        return this.userAuthFactories;
    }

    public void setUserAuthFactories(List<UserAuthFactory> userAuthFactories) {
        this.userAuthFactories = userAuthFactories;
    }

    @Override
    public ShellFactory getShellFactory() {
        return this.shellFactory;
    }

    public void setShellFactory(ShellFactory shellFactory) {
        this.shellFactory = shellFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public ServerProxyAcceptor getServerProxyAcceptor() {
        return this.proxyAcceptor;
    }

    @Override
    public void setServerProxyAcceptor(ServerProxyAcceptor proxyAcceptor) {
        this.proxyAcceptor = proxyAcceptor;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    @Override
    public List<SubsystemFactory> getSubsystemFactories() {
        return this.subsystemFactories;
    }

    public void setSubsystemFactories(List<SubsystemFactory> subsystemFactories) {
        this.subsystemFactories = subsystemFactories;
    }

    @Override
    public PasswordAuthenticator getPasswordAuthenticator() {
        return this.passwordAuthenticator;
    }

    @Override
    public void setPasswordAuthenticator(PasswordAuthenticator passwordAuthenticator) {
        this.passwordAuthenticator = passwordAuthenticator;
    }

    @Override
    public PublickeyAuthenticator getPublickeyAuthenticator() {
        return this.publickeyAuthenticator;
    }

    @Override
    public void setPublickeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.publickeyAuthenticator = publickeyAuthenticator;
    }

    @Override
    public KeyboardInteractiveAuthenticator getKeyboardInteractiveAuthenticator() {
        return this.interactiveAuthenticator;
    }

    @Override
    public void setKeyboardInteractiveAuthenticator(KeyboardInteractiveAuthenticator interactiveAuthenticator) {
        this.interactiveAuthenticator = interactiveAuthenticator;
    }

    @Override
    public GSSAuthenticator getGSSAuthenticator() {
        return this.gssAuthenticator;
    }

    @Override
    public void setGSSAuthenticator(GSSAuthenticator gssAuthenticator) {
        this.gssAuthenticator = gssAuthenticator;
    }

    @Override
    public HostBasedAuthenticator getHostBasedAuthenticator() {
        return this.hostBasedAuthenticator;
    }

    @Override
    public void setHostBasedAuthenticator(HostBasedAuthenticator hostBasedAuthenticator) {
        this.hostBasedAuthenticator = hostBasedAuthenticator;
    }

    public KeyPairProvider getKeyPairProvider() {
        return this.keyPairProvider;
    }

    public void setKeyPairProvider(KeyPairProvider keyPairProvider) {
        this.keyPairProvider = keyPairProvider;
    }

    @Override
    public HostKeyCertificateProvider getHostKeyCertificateProvider() {
        return this.hostKeyCertificateProvider;
    }

    @Override
    public void setHostKeyCertificateProvider(HostKeyCertificateProvider hostKeyCertificateProvider) {
        this.hostKeyCertificateProvider = hostKeyCertificateProvider;
    }

    @Override
    protected void checkConfig() {
        super.checkConfig();
        ValidateUtils.checkTrue((this.getPort() >= 0 ? 1 : 0) != 0, (String)"Bad port number: %d", (Object)this.getPort());
        List<UserAuthFactory> authFactories = ServerAuthenticationManager.resolveUserAuthFactories(this);
        this.setUserAuthFactories((List)ValidateUtils.checkNotNullAndNotEmpty(authFactories, (String)"UserAuthFactories not set", (Object[])new Object[0]));
        ValidateUtils.checkNotNullAndNotEmpty(this.getChannelFactories(), (String)"ChannelFactories not set", (Object[])new Object[0]);
        Objects.requireNonNull(this.getKeyPairProvider(), "HostKeyProvider not set");
        Objects.requireNonNull(this.getFileSystemFactory(), "FileSystemFactory not set");
        if (GenericUtils.isEmpty(this.getServiceFactories())) {
            this.setServiceFactories(DEFAULT_SERVICE_FACTORIES);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void start() throws IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Can not start the server again");
        }
        if (this.isStarted()) {
            return;
        }
        this.checkConfig();
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        this.acceptor = this.createAcceptor();
        this.setupSessionTimeout(this.sessionFactory);
        String hostsList = this.getHost();
        if (!GenericUtils.isEmpty((CharSequence)hostsList)) {
            String[] hosts;
            for (String host : hosts = GenericUtils.split((String)hostsList, (char)',')) {
                InetAddress[] inetAddresses;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("start() - resolve bind host={}", (Object)host);
                }
                for (InetAddress inetAddress : inetAddresses = InetAddress.getAllByName(host)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("start() - bind host={} / {}", (Object)host, (Object)inetAddress);
                    }
                    this.acceptor.bind((SocketAddress)new InetSocketAddress(inetAddress, this.port));
                    if (this.port != 0) continue;
                    SocketAddress selectedAddress = (SocketAddress)GenericUtils.head((Iterable)this.acceptor.getBoundAddresses());
                    this.port = ((InetSocketAddress)selectedAddress).getPort();
                    this.log.info("start() listen on auto-allocated port=" + this.port);
                }
            }
        } else {
            this.acceptor.bind((SocketAddress)new InetSocketAddress(this.port));
            if (this.port == 0) {
                SocketAddress selectedAddress = (SocketAddress)GenericUtils.head((Iterable)this.acceptor.getBoundAddresses());
                this.port = ((InetSocketAddress)selectedAddress).getPort();
                this.log.info("start() listen on auto-allocated port=" + this.port);
            }
        }
        this.started.set(true);
    }

    public void stop() throws IOException {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean immediately) throws IOException {
        if (!this.started.getAndSet(false)) {
            return;
        }
        try {
            Duration maxWait = immediately ? (Duration)CoreModuleProperties.STOP_WAIT_TIME.getRequired((PropertyResolver)this) : Duration.ofMillis(Long.MAX_VALUE);
            boolean successful = this.close(immediately).await(maxWait);
            if (!successful) {
                throw new SocketTimeoutException("Failed to receive closure confirmation within " + maxWait + " millis");
            }
        }
        finally {
            this.clearAttributes();
        }
    }

    public void open() throws IOException {
        this.start();
    }

    protected Closeable getInnerCloseable() {
        String closeId = this.toString();
        return this.builder().run((Object)closeId, () -> this.removeSessionTimeout(this.sessionFactory)).sequential(new Closeable[]{this.acceptor, this.ioServiceFactory}).run((Object)closeId, () -> {
            this.acceptor = null;
            this.ioServiceFactory = null;
            if (this.shutdownExecutor && this.executor != null && !this.executor.isShutdown()) {
                try {
                    this.executor.shutdownNow();
                }
                finally {
                    this.executor = null;
                }
            }
        }).build();
    }

    public List<AbstractSession> getActiveSessions() {
        ArrayList<AbstractSession> sessions = new ArrayList<AbstractSession>();
        for (IoSession ioSession : this.acceptor.getManagedSessions().values()) {
            AbstractSession session = AbstractSession.getSession(ioSession, true);
            if (session == null) continue;
            sessions.add(session);
        }
        return sessions;
    }

    protected IoAcceptor createAcceptor() {
        IoServiceFactory ioFactory = this.getIoServiceFactory();
        SessionFactory sessFactory = this.getSessionFactory();
        return ioFactory.createAcceptor((IoHandler)sessFactory);
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + Integer.toHexString(this.hashCode()) + "](port=" + this.getPort() + ")";
    }

    public static SshServer setUpDefaultServer() {
        ServerBuilder builder = ServerBuilder.builder();
        return (SshServer)builder.build();
    }
}

