/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SimpleListAttributeDefinition
extends ListAttributeDefinition {
    private final AttributeDefinition valueType;

    protected SimpleListAttributeDefinition(ListAttributeDefinition.Builder builder, AttributeDefinition valueType) {
        super(builder);
        this.valueType = valueType;
        assert (valueType.getType() != ModelType.OBJECT && valueType.getType() != ModelType.LIST);
    }

    public AttributeDefinition getValueType() {
        return this.valueType;
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle, prefix, resourceDescription);
        this.addValueTypeDescription(result, prefix, bundle);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle, String prefix, ModelNode operationDescription) {
        ModelNode result = super.addOperationParameterDescription(bundle, prefix, operationDescription);
        this.addValueTypeDescription(result, prefix, bundle);
        return result;
    }

    @Override
    public void addCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue) {
        if (attributeValue.isDefined()) {
            for (ModelNode element : attributeValue.asList()) {
                this.valueType.addCapabilityRequirements(context, resource, element);
            }
        }
    }

    @Override
    public void removeCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue) {
        if (attributeValue.isDefined()) {
            for (ModelNode element : attributeValue.asList()) {
                this.valueType.removeCapabilityRequirements(context, resource, element);
            }
        }
    }

    @Override
    protected CapabilityReferenceRecorder getReferenceRecorder() {
        return this.valueType.getReferenceRecorder();
    }

    @Override
    public boolean hasCapabilityRequirements() {
        return this.valueType.hasCapabilityRequirements();
    }

    @Override
    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle) {
        this.addValueTypeDescription(node);
    }

    protected void addValueTypeDescription(ModelNode node, String prefix, ResourceBundle bundle) {
        this.addValueTypeDescription(node);
    }

    @Override
    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.addValueTypeDescription(node);
    }

    @Override
    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.addValueTypeDescription(node);
    }

    @Override
    protected ModelNode convertParameterElementExpressions(ModelNode parameterElement) {
        boolean allowExp;
        boolean bl = allowExp = this.isAllowExpression() || this.valueType.isAllowExpression();
        if (allowExp && COMPLEX_TYPES.contains(this.valueType.getType())) {
            throw new IllegalStateException();
        }
        return allowExp ? SimpleListAttributeDefinition.convertStringExpression(parameterElement) : parameterElement;
    }

    @Override
    ModelNode parseResolvedValue(ModelNode original, ModelNode resolved) {
        return PrimitiveListAttributeDefinition.parseSingleElementToList(this, original, resolved);
    }

    private void addValueTypeDescription(ModelNode node) {
        node.get("value-type").set(this.valueType.getType());
    }

    public static class Builder
    extends ListAttributeDefinition.Builder<Builder, SimpleListAttributeDefinition> {
        private final AttributeDefinition valueType;
        private boolean wrapXmlList = true;

        public Builder(String name, AttributeDefinition valueType) {
            super(name);
            this.valueType = valueType;
            this.setElementValidator(valueType.getValidator());
        }

        public Builder(SimpleListAttributeDefinition basis) {
            super(basis);
            this.valueType = basis.getValueType();
        }

        public static Builder of(String name, AttributeDefinition valueType) {
            return new Builder(name, valueType);
        }

        public Builder setWrapXmlList(boolean wrap) {
            this.wrapXmlList = wrap;
            return this;
        }

        @Override
        public SimpleListAttributeDefinition build() {
            if (this.getAttributeMarshaller() == null) {
                this.setAttributeMarshaller(AttributeMarshallers.getSimpleListMarshaller(this.wrapXmlList));
            }
            return new SimpleListAttributeDefinition(this, this.valueType);
        }

        @Override
        public Builder setMaxSize(int maxSize) {
            return (Builder)super.setMaxSize(maxSize);
        }

        @Override
        public Builder setMinSize(int minSize) {
            return (Builder)super.setMinSize(minSize);
        }
    }
}

