/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.util.HashMap;
import java.util.Iterator;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.sasl.SaslMechanismSelector;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;
import org.xnio.sasl.SaslQop;
import org.xnio.sasl.SaslStrength;

public final class RemotingOptions {
    private static final String[] NO_STRINGS = new String[0];
    public static final Option<Integer> SEND_BUFFER_SIZE = Option.simple(RemotingOptions.class, (String)"SEND_BUFFER_SIZE", Integer.class);
    public static final int DEFAULT_SEND_BUFFER_SIZE = 8192;
    public static final Option<Integer> RECEIVE_BUFFER_SIZE = Option.simple(RemotingOptions.class, (String)"RECEIVE_BUFFER_SIZE", Integer.class);
    public static final int DEFAULT_RECEIVE_BUFFER_SIZE = 8192;
    public static final Option<Integer> BUFFER_REGION_SIZE = Option.simple(RemotingOptions.class, (String)"BUFFER_REGION_SIZE", Integer.class);
    public static final Option<Integer> TRANSMIT_WINDOW_SIZE = Option.simple(RemotingOptions.class, (String)"TRANSMIT_WINDOW_SIZE", Integer.class);
    public static final int INCOMING_CHANNEL_DEFAULT_TRANSMIT_WINDOW_SIZE = 131072;
    public static final int OUTGOING_CHANNEL_DEFAULT_TRANSMIT_WINDOW_SIZE = Integer.MAX_VALUE;
    public static final Option<Integer> RECEIVE_WINDOW_SIZE = Option.simple(RemotingOptions.class, (String)"RECEIVE_WINDOW_SIZE", Integer.class);
    public static final int INCOMING_CHANNEL_DEFAULT_RECEIVE_WINDOW_SIZE = 131072;
    public static final int OUTGOING_CHANNEL_DEFAULT_RECEIVE_WINDOW_SIZE = 131072;
    public static final Option<Integer> MAX_OUTBOUND_CHANNELS = Option.simple(RemotingOptions.class, (String)"MAX_OUTBOUND_CHANNELS", Integer.class);
    public static final int DEFAULT_MAX_OUTBOUND_CHANNELS = 40;
    public static final Option<Integer> MAX_INBOUND_CHANNELS = Option.simple(RemotingOptions.class, (String)"MAX_INBOUND_CHANNELS", Integer.class);
    public static final int DEFAULT_MAX_INBOUND_CHANNELS = 40;
    public static final Option<String> AUTHORIZE_ID = Option.simple(RemotingOptions.class, (String)"AUTHORIZE_ID", String.class);
    @Deprecated
    public static final Option<String> AUTH_USER_NAME = AUTHORIZE_ID;
    public static final Option<String> AUTH_REALM = Option.simple(RemotingOptions.class, (String)"AUTH_REALM", String.class);
    public static final Option<Integer> AUTHENTICATION_RETRIES = Option.simple(RemotingOptions.class, (String)"AUTHENTICATION_RETRIES", Integer.class);
    public static final int DEFAULT_AUTHENTICATION_RETRIES = 3;
    public static final Option<Integer> MAX_OUTBOUND_MESSAGES = Option.simple(RemotingOptions.class, (String)"MAX_OUTBOUND_MESSAGES", Integer.class);
    public static final int INCOMING_CHANNEL_DEFAULT_MAX_OUTBOUND_MESSAGES = 80;
    public static final int OUTGOING_CHANNEL_DEFAULT_MAX_OUTBOUND_MESSAGES = 65535;
    public static final Option<Integer> MAX_INBOUND_MESSAGES = Option.simple(RemotingOptions.class, (String)"MAX_INBOUND_MESSAGES", Integer.class);
    public static final int DEFAULT_MAX_INBOUND_MESSAGES = 80;
    public static final Option<Integer> HEARTBEAT_INTERVAL = Option.simple(RemotingOptions.class, (String)"HEARTBEAT_INTERVAL", Integer.class);
    public static final int DEFAULT_HEARTBEAT_INTERVAL = 60000;
    public static final Option<Long> MAX_INBOUND_MESSAGE_SIZE = Option.simple(RemotingOptions.class, (String)"MAX_INBOUND_MESSAGE_SIZE", Long.class);
    public static final long DEFAULT_MAX_INBOUND_MESSAGE_SIZE = Long.MAX_VALUE;
    public static final Option<Long> MAX_OUTBOUND_MESSAGE_SIZE = Option.simple(RemotingOptions.class, (String)"MAX_OUTBOUND_MESSAGE_SIZE", Long.class);
    public static final long DEFAULT_MAX_OUTBOUND_MESSAGE_SIZE = Long.MAX_VALUE;
    public static final Option<String> SERVER_NAME = Option.simple(RemotingOptions.class, (String)"SERVER_NAME", String.class);
    public static final Option<String> SASL_PROTOCOL = Option.simple(RemotingOptions.class, (String)"SASL_PROTOCOL", String.class);
    public static final String DEFAULT_SASL_PROTOCOL = "remote";
    public static final int DEFAULT_MESSAGE_ACK_TIMEOUT = 300000;

    private RemotingOptions() {
    }

    public static AuthenticationConfiguration mergeOptionsIntoAuthenticationConfiguration(OptionMap optionMap, AuthenticationConfiguration authenticationConfiguration) {
        Boolean serverAuth;
        SaslStrength strength;
        Boolean reuse;
        Iterator iterator;
        Sequence qop;
        Boolean passCredentials;
        Boolean noPlainText;
        Boolean noDictionary;
        Boolean noAnonymous;
        Boolean noActive;
        Boolean forwardSecrecy;
        String authzId;
        Assert.checkNotNullParam((String)"optionMap", (Object)optionMap);
        Assert.checkNotNullParam((String)"authenticationConfiguration", (Object)authenticationConfiguration);
        String saslProtocol = (String)optionMap.get(SASL_PROTOCOL);
        authenticationConfiguration = authenticationConfiguration.useSaslProtocol(saslProtocol != null ? saslProtocol : DEFAULT_SASL_PROTOCOL);
        String realm = (String)optionMap.get(AUTH_REALM);
        if (realm != null) {
            authenticationConfiguration = authenticationConfiguration.useRealm(realm);
        }
        if ((authzId = (String)optionMap.get(AUTHORIZE_ID)) != null) {
            authenticationConfiguration = authenticationConfiguration.useAuthorizationName(authzId);
        }
        Sequence mechanisms = (Sequence)optionMap.get(Options.SASL_MECHANISMS);
        Sequence disallowedMechs = (Sequence)optionMap.get(Options.SASL_DISALLOWED_MECHANISMS);
        if (mechanisms != null || disallowedMechs != null) {
            SaslMechanismSelector selector;
            SaslMechanismSelector saslMechanismSelector = selector = mechanisms != null ? SaslMechanismSelector.NONE.addMechanisms((String[])mechanisms.toArray((Object[])NO_STRINGS)) : SaslMechanismSelector.DEFAULT;
            if (disallowedMechs != null) {
                selector = selector.forbidMechanisms((String[])disallowedMechs.toArray((Object[])NO_STRINGS));
            }
            authenticationConfiguration = authenticationConfiguration.setSaslMechanismSelector(selector);
        }
        HashMap<String, Object> saslPropertiesMap = new HashMap<String, Object>();
        Sequence properties = (Sequence)optionMap.get(Options.SASL_PROPERTIES);
        if (properties != null) {
            for (Property property : properties) {
                saslPropertiesMap.put(property.getKey(), property.getValue());
            }
        }
        if ((forwardSecrecy = (Boolean)optionMap.get(Options.SASL_POLICY_FORWARD_SECRECY)) != null) {
            saslPropertiesMap.put("javax.security.sasl.policy.forward", forwardSecrecy.toString());
        }
        if ((noActive = (Boolean)optionMap.get(Options.SASL_POLICY_NOACTIVE)) != null) {
            saslPropertiesMap.put("javax.security.sasl.policy.noactive", noActive.toString());
        }
        if ((noAnonymous = (Boolean)optionMap.get(Options.SASL_POLICY_NOANONYMOUS)) != null) {
            saslPropertiesMap.put("javax.security.sasl.policy.noanonymous", noAnonymous.toString());
        }
        if ((noDictionary = (Boolean)optionMap.get(Options.SASL_POLICY_NODICTIONARY)) != null) {
            saslPropertiesMap.put("javax.security.sasl.policy.nodictionary", noDictionary.toString());
        }
        if ((noPlainText = (Boolean)optionMap.get(Options.SASL_POLICY_NOPLAINTEXT)) != null) {
            saslPropertiesMap.put("javax.security.sasl.policy.noplaintext", noPlainText.toString());
        }
        if ((passCredentials = (Boolean)optionMap.get(Options.SASL_POLICY_PASS_CREDENTIALS)) != null) {
            saslPropertiesMap.put("javax.security.sasl.policy.credentials", passCredentials.toString());
        }
        if ((qop = (Sequence)optionMap.get(Options.SASL_QOP)) != null && (iterator = qop.iterator()).hasNext()) {
            StringBuilder b = new StringBuilder().append(((SaslQop)iterator.next()).getString());
            while (iterator.hasNext()) {
                b.append(',').append(((SaslQop)iterator.next()).getString());
            }
            saslPropertiesMap.put("javax.security.sasl.qop", b.toString());
        }
        if ((reuse = (Boolean)optionMap.get(Options.SASL_REUSE)) != null) {
            saslPropertiesMap.put("javax.security.sasl.reuse", reuse.toString());
        }
        if ((strength = (SaslStrength)optionMap.get(Options.SASL_STRENGTH)) != null) {
            switch (strength) {
                case LOW: {
                    saslPropertiesMap.put("javax.security.sasl.strength", "low");
                    break;
                }
                case MEDIUM: {
                    saslPropertiesMap.put("javax.security.sasl.strength", "medium");
                    break;
                }
                case HIGH: {
                    saslPropertiesMap.put("javax.security.sasl.strength", "high");
                    break;
                }
                default: {
                    throw Assert.impossibleSwitchCase((Object)strength);
                }
            }
        }
        if ((serverAuth = (Boolean)optionMap.get(Options.SASL_SERVER_AUTH)) != null) {
            saslPropertiesMap.put("javax.security.sasl.server.authentication", serverAuth.toString());
        }
        if (!saslPropertiesMap.isEmpty()) {
            authenticationConfiguration = authenticationConfiguration.useMechanismProperties(saslPropertiesMap);
        }
        return authenticationConfiguration;
    }
}

