/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.common.beans.property;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.common.beans.property.BeanUtils;
import org.jboss.common.beans.property.PropertyEditorSupport;

public class InetAddressEditor
extends PropertyEditorSupport<InetAddress> {
    public InetAddressEditor() {
        super(InetAddress.class);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            if (BeanUtils.isNull(text)) {
                this.setValue(null);
                return;
            }
            String value = text;
            if (text.startsWith("/")) {
                value = text.substring(1);
            }
            this.setValue(InetAddress.getByName(value));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Failed to parse: " + text, e);
        }
    }

    @Override
    public String getAsText() {
        InetAddress inetAddress = (InetAddress)this.getValue();
        if (inetAddress == null) {
            return null;
        }
        String value = inetAddress.toString();
        String[] tokens = value.split("/");
        if (tokens[0].length() > 0) {
            return tokens[0];
        }
        return tokens[1];
    }
}

