/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.elytron.ElytronExtension;

class AuthenticationContextDependencyProcessor
implements DeploymentUnitProcessor {
    private volatile String defaultAuthenticationContext;

    AuthenticationContextDependencyProcessor() {
    }

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        String defaultAuthenticationContext = this.defaultAuthenticationContext;
        if (defaultAuthenticationContext != null) {
            CapabilityServiceSupport capabilityServiceSupport = (CapabilityServiceSupport)context.getDeploymentUnit().getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            ServiceName serviceName = capabilityServiceSupport.getCapabilityServiceName("org.wildfly.security.authentication-context", new String[]{defaultAuthenticationContext});
            context.addDependency(serviceName, ElytronExtension.AUTHENTICATION_CONTEXT_KEY);
        }
    }

    public void undeploy(DeploymentUnit unit) {
    }

    public void setDefaultAuthenticationContext(String defaultAuthenticationContext) {
        this.defaultAuthenticationContext = defaultAuthenticationContext;
    }
}

