/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.repository;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.repository.logging.DeploymentRepositoryLogger;

class HashUtil {
    private static char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private HashUtil() {
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            builder.append(table[b >> 4 & 0xF]).append(table[b & 0xF]);
        }
        return builder.toString();
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int x = Character.digit(s.charAt(j), 16) << 4;
            x |= Character.digit(s.charAt(++j), 16);
            ++j;
            data[i] = (byte)(x & 0xFF);
            ++i;
        }
        return data;
    }

    public static boolean isEachHexHashInTable(String s) {
        char[] array;
        for (char c : array = s.toCharArray()) {
            if (Arrays.binarySearch(table, c) >= 0) continue;
            return false;
        }
        return true;
    }

    public static byte[] hashContent(MessageDigest messageDigest, InputStream stream) throws IOException {
        messageDigest.reset();
        try (DigestInputStream dis = new DigestInputStream(stream, messageDigest);){
            byte[] bytes = new byte[8192];
            while (dis.read(bytes) > -1) {
            }
        }
        return messageDigest.digest();
    }

    public static byte[] hashPath(MessageDigest messageDigest, Path path) throws IOException {
        try (InputStream in = HashUtil.getRecursiveContentStream(path);){
            byte[] byArray = HashUtil.hashContent(messageDigest, in);
            return byArray;
        }
    }

    private static InputStream getRecursiveContentStream(Path path) {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try {
                return new SequenceInputStream(new ByteArrayInputStream(path.getFileName().toString().getBytes(StandardCharsets.UTF_8)), Files.newInputStream(path, new OpenOption[0]));
            }
            catch (IOException ex) {
                throw DeploymentRepositoryLogger.ROOT_LOGGER.hashingError(ex, path);
            }
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                Vector<ByteArrayInputStream> v = new Vector<ByteArrayInputStream>();
                v.add(new ByteArrayInputStream(path.getFileName().toString().getBytes(StandardCharsets.UTF_8)));
                try (Stream<Path> paths = Files.list(path);){
                    v.addAll(paths.sorted((path1, path2) -> path1.compareTo((Path)path2)).map(p -> HashUtil.getRecursiveContentStream(p)).collect(Collectors.toList()));
                }
                return new SequenceInputStream(v.elements());
            }
            catch (IOException ex) {
                throw DeploymentRepositoryLogger.ROOT_LOGGER.hashingError(ex, path);
            }
        }
        return HashUtil.emptyStream();
    }

    public static InputStream emptyStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
    }
}

