/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import org.jboss.security.PicketBoxMessages;

public class KeyStoreUtil {
    public static KeyStore getKeyStore(File keyStoreFile, char[] storePass) throws GeneralSecurityException, IOException {
        return KeyStoreUtil.getKeyStore(KeyStore.getDefaultType(), keyStoreFile, storePass);
    }

    public static KeyStore getKeyStore(String fileURL, char[] storePass) throws GeneralSecurityException, IOException {
        return KeyStoreUtil.getKeyStore(KeyStore.getDefaultType(), fileURL, storePass);
    }

    public static KeyStore getKeyStore(URL url, char[] storePass) throws GeneralSecurityException, IOException {
        return KeyStoreUtil.getKeyStore(KeyStore.getDefaultType(), url, storePass);
    }

    public static KeyStore getKeyStore(InputStream ksStream, char[] storePass) throws GeneralSecurityException, IOException {
        return KeyStoreUtil.getKeyStore(KeyStore.getDefaultType(), ksStream, storePass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(String keyStoreType, File keyStoreFile, char[] storePass) throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(keyStoreFile);
            keyStore = KeyStoreUtil.getKeyStore(keyStoreType, fis, storePass);
        }
        catch (Throwable throwable) {
            KeyStoreUtil.safeClose(fis);
            throw throwable;
        }
        KeyStoreUtil.safeClose(fis);
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(String keyStoreType, String fileURL, char[] storePass) throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        if (fileURL == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("fileURL");
        }
        File file = new File(fileURL);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            keyStore = KeyStoreUtil.getKeyStore(keyStoreType, fis, storePass);
        }
        catch (Throwable throwable) {
            KeyStoreUtil.safeClose(fis);
            throw throwable;
        }
        KeyStoreUtil.safeClose(fis);
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(String keyStoreType, URL url, char[] storePass) throws GeneralSecurityException, IOException {
        if (url == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("url");
        }
        InputStream is = null;
        try {
            is = url.openStream();
            KeyStore keyStore = KeyStoreUtil.getKeyStore(keyStoreType, is, storePass);
            return keyStore;
        }
        finally {
            KeyStoreUtil.safeClose(is);
        }
    }

    public static KeyStore getKeyStore(String keyStoreType, InputStream ksStream, char[] storePass) throws GeneralSecurityException, IOException {
        if (ksStream == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("ksStream");
        }
        KeyStore ks = KeyStore.getInstance(keyStoreType == null ? KeyStore.getDefaultType() : keyStoreType);
        ks.load(ksStream, storePass);
        return ks;
    }

    public static KeyPair generateKeyPair(String algo) throws GeneralSecurityException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(algo);
        return kpg.genKeyPair();
    }

    public static PublicKey getPublicKey(KeyStore ks, String alias, char[] password) throws KeyStoreException, NoSuchAlgorithmException, GeneralSecurityException {
        Certificate cert;
        PublicKey publicKey = null;
        Key key = ks.getKey(alias, password);
        if (key instanceof PrivateKey) {
            cert = ks.getCertificate(alias);
            publicKey = cert.getPublicKey();
        }
        if (publicKey == null && (cert = ks.getCertificate(alias)) != null) {
            publicKey = cert.getPublicKey();
        }
        return publicKey;
    }

    public static void addCertificate(File keystoreFile, char[] storePass, String alias, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStoreUtil.addCertificate(KeyStore.getDefaultType(), keystoreFile, storePass, alias, cert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCertificate(String keyStoreType, File keystoreFile, char[] storePass, String alias, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore keystore = KeyStoreUtil.getKeyStore(keyStoreType, keystoreFile, storePass);
        keystore.setCertificateEntry(alias, cert);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(keystoreFile);
            keystore.store(out, storePass);
            out.close();
        }
        catch (Throwable throwable) {
            KeyStoreUtil.safeClose(out);
            throw throwable;
        }
        KeyStoreUtil.safeClose(out);
    }

    public static KeyPair getPrivateKey(KeyStore keystore, String alias, char[] password) throws Exception {
        Key key = keystore.getKey(alias, password);
        if (key instanceof PrivateKey) {
            Certificate cert = keystore.getCertificate(alias);
            PublicKey publicKey = cert.getPublicKey();
            return new KeyPair(publicKey, (PrivateKey)key);
        }
        return null;
    }

    public static KeyStore createKeyStore(String keyStoreType, char[] keyStorePWD) throws Exception {
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        ks.load(null, keyStorePWD);
        return ks;
    }

    private static void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void safeClose(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

