/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery.impl;

import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.common.Assert;
import org.wildfly.discovery.ServiceRegistration;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.spi.RegistryProvider;

public final class MutableRegistryProvider
implements RegistryProvider {
    private final AtomicReference<RegistryProvider> delegateRef;

    public MutableRegistryProvider(RegistryProvider initialProvider) {
        Assert.checkNotNullParam((String)"initialProvider", (Object)initialProvider);
        this.delegateRef = new AtomicReference<RegistryProvider>(initialProvider);
    }

    public MutableRegistryProvider() {
        this(EMPTY);
    }

    @Override
    public ServiceRegistration registerService(ServiceURL serviceURL) {
        Assert.checkNotNullParam((String)"serviceURL", (Object)serviceURL);
        return this.delegateRef.get().registerService(serviceURL);
    }

    @Override
    public ServiceRegistration registerServices(ServiceURL ... serviceURLs) {
        Assert.checkNotNullParam((String)"serviceURLs", (Object)serviceURLs);
        return this.delegateRef.get().registerServices(serviceURLs);
    }

    public void setRegistryProvider(RegistryProvider delegateProvider) {
        Assert.checkNotNullParam((String)"delegateProvider", (Object)delegateProvider);
        this.delegateRef.set(delegateProvider);
    }
}

