/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractNumberDeserializer;

public class FloatTypeDeserializer
extends AbstractNumberDeserializer<Float> {
    public FloatTypeDeserializer(Customization customization) {
        super(Float.class, customization);
    }

    @Override
    protected Float deserialize(String jsonValue, Unmarshaller unmarshaller, Type rtType) {
        return this.deserializeFormatted(jsonValue, false, unmarshaller.getJsonbContext()).map(num -> Float.valueOf(Float.parseFloat(num.toString()))).orElseGet(() -> {
            try {
                return Float.valueOf(Float.parseFloat(jsonValue));
            }
            catch (NumberFormatException e) {
                throw new JsonbException(Messages.getMessage(MessageKeys.DESERIALIZE_VALUE_ERROR, Float.class));
            }
        });
    }
}

