/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence.yaml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.ParsedBootOp;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.ConfigurationExtension;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class YamlConfigurationExtension
implements ConfigurationExtension {
    private static final String CONFIGURATION_ROOT_KEY = "wildfly-configuration";
    private static final String YAML_CONFIG = "--yaml";
    private static final String SHORT_YAML_CONFIG = "-y";
    private boolean needReload;
    private Path[] files;
    private final List<Map<String, Object>> configs = new ArrayList<Map<String, Object>>();
    private static final String[] EXCLUDED_ELEMENTS = new String[]{" deployment", "extension", "deployment-overlay"};

    @Override
    public ConfigurationExtension load(Path ... files) {
        this.files = files;
        this.load();
        return this;
    }

    private void load() {
        long start = System.currentTimeMillis();
        for (Path file : this.files) {
            if (file != null && Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
                Map yamlConfig = Collections.emptyMap();
                try {
                    String[] stringArray = null;
                    try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
                        Yaml yaml = new Yaml((BaseConstructor)new OperationConstructor());
                        yamlConfig = (Map)yaml.load(inputStream);
                    }
                    catch (Throwable object) {
                        stringArray = object;
                        throw object;
                    }
                }
                catch (IOException ioex) {
                    throw ControllerLogger.MGMT_OP_LOGGER.failedToParseYamlConfigurationFile(file.toAbsolutePath().toString(), ioex);
                }
                if (!yamlConfig.containsKey(CONFIGURATION_ROOT_KEY)) continue;
                Map config = (Map)yamlConfig.get(CONFIGURATION_ROOT_KEY);
                for (String excluded : EXCLUDED_ELEMENTS) {
                    config.remove(excluded);
                }
                this.configs.add(config);
                continue;
            }
            throw ControllerLogger.MGMT_OP_LOGGER.missingYamlFile(file != null ? file.toAbsolutePath().toString() : "");
        }
        ControllerLogger.MGMT_OP_LOGGER.loadingYamlFiles(System.currentTimeMillis() - start);
        this.needReload = false;
    }

    @Override
    public boolean shouldProcessOperations(RunningMode mode) {
        return !this.configs.isEmpty() && (RunningMode.ADMIN_ONLY != mode || null == WildFlySecurityManager.getPropertyPrivileged((String)"org.wildfly.internal.cli.boot.hook.script", null));
    }

    @Override
    public void processOperations(ImmutableManagementResourceRegistration rootRegistration, List<ParsedBootOp> postExtensionOps) {
        if (this.needReload) {
            this.load();
        }
        ControllerLogger.MGMT_OP_LOGGER.debug("We are applying YAML files to the configuration");
        HashMap<PathAddress, ParsedBootOp> xmlOperations = new HashMap<PathAddress, ParsedBootOp>();
        for (ParsedBootOp parsedBootOp : postExtensionOps) {
            if (parsedBootOp.getChildOperations().isEmpty()) {
                xmlOperations.put(parsedBootOp.getAddress(), parsedBootOp);
                continue;
            }
            for (ModelNode childOp : parsedBootOp.getChildOperations()) {
                ParsedBootOp subOp = new ParsedBootOp(childOp, null);
                xmlOperations.put(subOp.getAddress(), subOp);
            }
        }
        for (Map map : this.configs) {
            this.processResource(PathAddress.EMPTY_ADDRESS, new HashMap<String, Object>(map), rootRegistration, rootRegistration, xmlOperations, postExtensionOps, false);
        }
        this.configs.clear();
        this.needReload = true;
    }

    private void processResource(PathAddress parentAddress, Map<String, Object> yaml, ImmutableManagementResourceRegistration rootRegistration, ImmutableManagementResourceRegistration resourceRegistration, Map<PathAddress, ParsedBootOp> xmlOperations, List<ParsedBootOp> postExtensionOps, boolean placeHolder) {
        for (String name : yaml.keySet()) {
            Operation yamlOperation;
            Map map;
            Object value;
            PathAddress address;
            if (resourceRegistration.getChildNames(PathAddress.EMPTY_ADDRESS).contains(name) || placeHolder) {
                address = placeHolder ? parentAddress.getParent().append(parentAddress.getLastElement().getKey(), name) : parentAddress.append(name);
                value = yaml.get(name);
                if (value instanceof Map) {
                    map = (Map)value;
                    ImmutableManagementResourceRegistration childResourceRegistration = rootRegistration.getSubModel(address);
                    if (childResourceRegistration != null) {
                        this.processResource(address, map, rootRegistration, childResourceRegistration, xmlOperations, postExtensionOps, false);
                        continue;
                    }
                    if (placeHolder) {
                        ControllerLogger.MGMT_OP_LOGGER.noResourceRegistered(address.toCLIStyleString());
                        continue;
                    }
                    ControllerLogger.MGMT_OP_LOGGER.debugf("No registration found for address %s", address.toCLIStyleString());
                    this.processResource(address, map, rootRegistration, resourceRegistration, xmlOperations, postExtensionOps, true);
                    continue;
                }
                if (value == null && !this.isExistingResource(xmlOperations, address)) {
                    OperationEntry operationEntry = rootRegistration.getOperationEntry(address, "add");
                    this.processAttributes(address, rootRegistration, operationEntry, Collections.emptyMap(), postExtensionOps);
                    continue;
                }
                if (value != null && value instanceof Operation) {
                    yamlOperation = (Operation)Operation.class.cast(value);
                    if (this.isExistingResource(xmlOperations, address)) {
                        postExtensionOps.addAll(yamlOperation.getOperations(rootRegistration, address, name));
                        continue;
                    }
                    if (yamlOperation instanceof RemoveOperation) continue;
                    throw ControllerLogger.MGMT_OP_LOGGER.noResourceForUndefiningAttribute(name, address.toCLIStyleString());
                }
                if (this.isExistingResource(xmlOperations, address)) continue;
                ControllerLogger.MGMT_OP_LOGGER.noAttributeSetForAddress(address.toCLIStyleString());
                continue;
            }
            address = parentAddress.getParent().append(parentAddress.getLastElement().getKey(), name);
            if (this.isExistingResource(xmlOperations, address)) {
                ControllerLogger.MGMT_OP_LOGGER.debugf("Resource for address %s already exists", address.toCLIStyleString());
                value = yaml.get(name);
                if (value instanceof Map) {
                    map = (Map)value;
                    this.processResource(address, map, rootRegistration, rootRegistration.getSubModel(address), xmlOperations, postExtensionOps, false);
                    continue;
                }
                if (value == null || !(value instanceof Operation)) continue;
                yamlOperation = (Operation)Operation.class.cast(value);
                postExtensionOps.addAll(yamlOperation.getOperations(rootRegistration, address, name));
                continue;
            }
            value = yaml.get(name);
            if (resourceRegistration.getAttributeNames(PathAddress.EMPTY_ADDRESS).contains(name)) {
                if (value == null) continue;
                ControllerLogger.MGMT_OP_LOGGER.debugf("We are processing the attribute %s for address %s", name, address.getParent().toCLIStyleString());
                this.processAttribute(parentAddress, rootRegistration, name, value, postExtensionOps);
                continue;
            }
            ImmutableManagementResourceRegistration childResourceRegistration = rootRegistration.getSubModel(address);
            if (childResourceRegistration != null) {
                Map map2;
                OperationEntry operationEntry = rootRegistration.getOperationEntry(address, "add");
                if (operationEntry == null) {
                    ControllerLogger.MGMT_OP_LOGGER.debugf("Resource for address %s is a placeholder for %s so we don't create it", address.toCLIStyleString(), childResourceRegistration.getPathAddress().toCLIStyleString());
                    if (value instanceof Map) {
                        map2 = (Map)value;
                        this.processResource(address, map2, rootRegistration, childResourceRegistration, xmlOperations, postExtensionOps, false);
                        continue;
                    }
                    if (value == null) continue;
                    ControllerLogger.MGMT_OP_LOGGER.unexpectedValueForResource(value, address.toCLIStyleString(), name);
                    continue;
                }
                ControllerLogger.MGMT_OP_LOGGER.debugf("Resource for address %s needs to be created with parameters %s", address.toCLIStyleString(), Arrays.stream(operationEntry.getOperationDefinition().getParameters()).map(AttributeDefinition::getName).collect(Collectors.joining()));
                if (value instanceof Map) {
                    map2 = (Map)value;
                    this.processAttributes(address, rootRegistration, operationEntry, map2, postExtensionOps);
                    this.processResource(address, map2, rootRegistration, childResourceRegistration, xmlOperations, postExtensionOps, false);
                    continue;
                }
                if (value == null) continue;
                ControllerLogger.MGMT_OP_LOGGER.unexpectedValueForResource(value, address.toCLIStyleString(), name);
                continue;
            }
            ControllerLogger.MGMT_OP_LOGGER.noResourceRegistered(address.toCLIStyleString(), resourceRegistration.getPathAddress().toCLIStyleString());
        }
    }

    private boolean isExistingResource(Map<PathAddress, ParsedBootOp> xmlOperations, PathAddress address) {
        return xmlOperations.containsKey(address);
    }

    private void processAttribute(PathAddress address, ImmutableManagementResourceRegistration rootRegistration, String attributeName, Object value, List<ParsedBootOp> postExtensionOps) {
        AttributeDefinition att;
        assert (value != null);
        AttributeAccess attributeAccess = rootRegistration.getAttributeAccess(address, attributeName);
        if (attributeAccess.getStorageType() == AttributeAccess.Storage.CONFIGURATION && attributeAccess.getAccessType() == AttributeAccess.AccessType.READ_WRITE && (att = attributeAccess.getAttributeDefinition()) != null && !att.isResourceOnly()) {
            switch (att.getType()) {
                case OBJECT: {
                    OperationEntry operationEntry = rootRegistration.getOperationEntry(address, "write-attribute");
                    ModelNode op = this.createOperation(address, operationEntry);
                    op.get("name").set(attributeName);
                    op.get("value").set(this.processObjectAttribute((ObjectTypeAttributeDefinition)att, (Map)value));
                    ControllerLogger.MGMT_OP_LOGGER.debugf("Updating attribute %s for resource %s with operation %s", attributeName, address, op);
                    postExtensionOps.add(new ParsedBootOp(op, operationEntry.getOperationHandler()));
                    break;
                }
                case LIST: {
                    if (value instanceof Operation) {
                        postExtensionOps.addAll(((Operation)value).getOperations(rootRegistration, address, att.getName()));
                        break;
                    }
                    OperationEntry operationEntry = rootRegistration.getOperationEntry(address, "write-attribute");
                    ModelNode op = this.createOperation(address, operationEntry);
                    op.get("name").set(attributeName);
                    ModelNode list = op.get("value").setEmptyList();
                    this.processListAttribute((ListAttributeDefinition)att, list, value);
                    break;
                }
                default: {
                    if (value instanceof Operation) {
                        postExtensionOps.addAll(((Operation)value).getOperations(rootRegistration, address, attributeName));
                        break;
                    }
                    OperationEntry operationEntry = rootRegistration.getOperationEntry(address, "write-attribute");
                    ModelNode op = this.createOperation(address, operationEntry);
                    op.get("name").set(attributeName);
                    op.get("value").set(value.toString());
                    ControllerLogger.MGMT_OP_LOGGER.debugf("Updating attribute %s for resource %s with operation %s", attributeName, address, op);
                    postExtensionOps.add(new ParsedBootOp(op, operationEntry.getOperationHandler()));
                }
            }
        }
    }

    private void processAttributes(PathAddress address, ImmutableManagementResourceRegistration rootRegistration, OperationEntry operationEntry, Map<String, Object> map, List<ParsedBootOp> postExtensionOps) {
        HashSet<AttributeDefinition> attributes = new HashSet<AttributeDefinition>();
        for (AttributeAccess attributeAccess : rootRegistration.getAttributes(address).values()) {
            AttributeDefinition def;
            if (attributeAccess.getStorageType() != AttributeAccess.Storage.CONFIGURATION || (def = attributeAccess.getAttributeDefinition()) == null || def.isResourceOnly()) continue;
            attributes.add(def);
        }
        attributes.addAll(Arrays.asList(operationEntry.getOperationDefinition().getParameters()));
        ModelNode op = this.createOperation(address, operationEntry);
        block5: for (AttributeDefinition att : attributes) {
            if (!map.containsKey(att.getName())) continue;
            Object value = map.get(att.getName());
            map.remove(att.getName());
            switch (att.getType()) {
                case OBJECT: {
                    op.get(att.getName()).set(this.processObjectAttribute((ObjectTypeAttributeDefinition)att, (Map)value));
                    continue block5;
                }
                case LIST: {
                    ModelNode list = op.get(att.getName()).setEmptyList();
                    this.processListAttribute((ListAttributeDefinition)att, list, value);
                    continue block5;
                }
            }
            op.get(att.getName()).set(value.toString());
        }
        ParsedBootOp parsedBootOp = new ParsedBootOp(op, operationEntry.getOperationHandler());
        ControllerLogger.MGMT_OP_LOGGER.debugf("Adding resource with operation %s", op);
        postExtensionOps.add(parsedBootOp);
    }

    private ModelNode createOperation(PathAddress address, OperationEntry operationEntry) {
        ModelNode op = new ModelNode();
        op.get("operation").set(operationEntry.getOperationDefinition().getName());
        op.get("address").set(address.toModelNode());
        return op;
    }

    private ModelNode processObjectAttribute(ObjectTypeAttributeDefinition att, Map<String, Object> map) {
        ModelNode objectNode = new ModelNode();
        block4: for (AttributeDefinition child : att.getValueTypes()) {
            if (!map.containsKey(child.getName())) continue;
            Object value = map.get(child.getName());
            switch (child.getType()) {
                case OBJECT: {
                    objectNode.get(child.getName()).set(this.processObjectAttribute((ObjectTypeAttributeDefinition)child, (Map)value));
                    continue block4;
                }
                case LIST: {
                    ModelNode list = objectNode.get(child.getName()).setEmptyList();
                    this.processListAttribute((ListAttributeDefinition)child, list, value);
                    continue block4;
                }
                default: {
                    objectNode.get(child.getName()).set(value.toString());
                }
            }
        }
        return objectNode;
    }

    private void processListAttribute(ListAttributeDefinition att, ModelNode list, Object value) {
        AttributeDefinition type = att.getValueAttributeDefinition();
        if (type == null) {
            throw ControllerLogger.ROOT_LOGGER.missingListAttributeValueType(att.getName());
        }
        boolean isObject = ModelType.OBJECT == type.getType();
        for (Object entry : (Iterable)value) {
            if (isObject) {
                list.add(this.processObjectAttribute((ObjectTypeAttributeDefinition)type, (Map)entry));
                continue;
            }
            list.add(entry.toString());
        }
    }

    @Override
    public String[] getCommandLineUsageArguments() {
        return new String[]{"--yaml=[<paths>]", "-y=[<paths>]"};
    }

    @Override
    public boolean commandLineContainsArgument(String arg) {
        return arg.startsWith(YAML_CONFIG) || arg.startsWith(SHORT_YAML_CONFIG);
    }

    @Override
    public String getCommandLineInstructions() {
        return ControllerLogger.MGMT_OP_LOGGER.argYaml();
    }

    private class OperationConstructor
    extends Constructor {
        private final Tag REMOVE = new Tag("!remove");
        private final Tag UNDEFINE = new Tag("!undefine");
        private final Tag ADD = new Tag("!list-add");

        public OperationConstructor() {
            this.yamlConstructors.put(this.REMOVE, new ConstructRemoveOperation());
            this.yamlConstructors.put(this.UNDEFINE, new ConstructUndefineOperation());
            this.yamlConstructors.put(this.ADD, new ConstructListAddOperation());
        }

        protected void flattenMapping(MappingNode node) {
            this.processDuplicateKeys(node);
            if (node.isMerged()) {
                node.setValue(this.mergeNode(node, false, new HashMap<Object, Integer>(), new ArrayList<NodeTuple>()));
            }
        }

        protected void processDuplicateKeys(MappingNode node) {
            List nodeValue = node.getValue();
            HashMap<Object, Integer> keys = new HashMap<Object, Integer>(nodeValue.size());
            int i = 0;
            for (NodeTuple tuple : nodeValue) {
                Node keyNode = tuple.getKeyNode();
                if (!keyNode.getTag().equals((Object)Tag.MERGE)) {
                    Integer prevIndex;
                    Object key = this.constructObject(keyNode);
                    if (key != null) {
                        try {
                            key.hashCode();
                        }
                        catch (Exception e) {
                            ControllerLogger.MGMT_OP_LOGGER.infof("Error processing duplicate key %s", key, e);
                        }
                    }
                    if ((prevIndex = keys.put(key, i)) != null) {
                        node.setMerged(true);
                        ControllerLogger.MGMT_OP_LOGGER.debugf("Duplicate key found  %s", key);
                    }
                }
                ++i;
            }
        }

        private List<NodeTuple> mergeNode(MappingNode node, boolean isPreffered, Map<Object, Integer> key2index, List<NodeTuple> values) {
            Iterator iter = node.getValue().iterator();
            block13: while (iter.hasNext()) {
                NodeTuple nodeTuple = (NodeTuple)iter.next();
                Node keyNode = nodeTuple.getKeyNode();
                Node valueNode = nodeTuple.getValueNode();
                if (keyNode.getTag().equals((Object)Tag.MERGE)) {
                    iter.remove();
                    switch (valueNode.getNodeId()) {
                        case mapping: {
                            MappingNode mn = (MappingNode)valueNode;
                            this.mergeNode(mn, false, key2index, values);
                            continue block13;
                        }
                        case sequence: {
                            SequenceNode sn = (SequenceNode)valueNode;
                            List vals = sn.getValue();
                            for (Node subnode : vals) {
                                if (!(subnode instanceof MappingNode)) {
                                    throw new YAMLException(ControllerLogger.MGMT_OP_LOGGER.errorConstructingYAMLMapping(node.getStartMark(), subnode.getNodeId()));
                                }
                                MappingNode mnode = (MappingNode)subnode;
                                this.mergeNode(mnode, false, key2index, values);
                            }
                            continue block13;
                        }
                        default: {
                            throw new YAMLException(ControllerLogger.MGMT_OP_LOGGER.errorConstructingYAMLMapping(node.getStartMark(), valueNode.getNodeId()));
                        }
                    }
                }
                Object key = this.constructObject(keyNode);
                if (!key2index.containsKey(key)) {
                    values.add(nodeTuple);
                    ControllerLogger.MGMT_OP_LOGGER.debugf("First key %s %s", key, nodeTuple.getValueNode());
                    key2index.put(key, values.size() - 1);
                    continue;
                }
                if (isPreffered) {
                    values.set(key2index.get(key), nodeTuple);
                    continue;
                }
                ControllerLogger.MGMT_OP_LOGGER.debugf("Other value found for key %s %s", key, nodeTuple.getValueNode());
                int index = key2index.get(key);
                NodeTuple firstTuple = values.get(index);
                switch (firstTuple.getValueNode().getNodeId()) {
                    case mapping: {
                        if (firstTuple.getValueNode().getNodeId() == NodeId.mapping) {
                            MappingNode mn1 = (MappingNode)firstTuple.getValueNode();
                            if (this.REMOVE.equals((Object)valueNode.getTag())) {
                                values.set(key2index.get(key), nodeTuple);
                                break;
                            }
                            MappingNode mn = (MappingNode)valueNode;
                            this.mergeNode(mn, false, key2index, mn1.getValue());
                            break;
                        }
                        if (!this.REMOVE.equals((Object)firstTuple.getValueNode().getTag())) continue block13;
                        values.set(key2index.get(key), nodeTuple);
                        break;
                    }
                    case scalar: {
                        values.set(key2index.get(key), nodeTuple);
                        break;
                    }
                    case sequence: {
                        SequenceNode sn = (SequenceNode)valueNode;
                        List vals = sn.getValue();
                        block15: for (Node subnode : vals) {
                            switch (subnode.getNodeId()) {
                                case mapping: {
                                    MappingNode mnode = (MappingNode)subnode;
                                    this.mergeNode(mnode, false, key2index, values);
                                    continue block15;
                                }
                                case scalar: {
                                    ((SequenceNode)values.get(key2index.get(key)).getValueNode()).getValue().add(subnode);
                                    continue block15;
                                }
                            }
                            throw new YAMLException(ControllerLogger.MGMT_OP_LOGGER.errorConstructingYAMLMapping(node.getStartMark(), subnode.getNodeId()));
                        }
                        continue block13;
                    }
                    default: {
                        throw new YAMLException(ControllerLogger.MGMT_OP_LOGGER.errorConstructingYAMLMapping(node.getStartMark(), firstTuple.getValueNode().getNodeId()));
                    }
                }
            }
            return values;
        }

        private class ConstructListAddOperation
        implements Construct {
            private final Construct delegate;

            private ConstructListAddOperation() {
                this.delegate = new SafeConstructor.ConstructYamlSeq((SafeConstructor)OperationConstructor.this);
            }

            public Object construct(Node node) {
                return new ListAddOperation((List)this.delegate.construct(node));
            }

            public void construct2ndStep(Node node, Object object) {
                this.delegate.construct2ndStep(node, object);
            }
        }

        private class ConstructUndefineOperation
        extends AbstractConstruct {
            private ConstructUndefineOperation() {
            }

            public Object construct(Node node) {
                return new UndefineOperation();
            }
        }

        private class ConstructRemoveOperation
        extends AbstractConstruct {
            private ConstructRemoveOperation() {
            }

            public Object construct(Node node) {
                return new RemoveOperation();
            }
        }
    }

    private class ListAddOperation
    implements Operation {
        private final List<? extends Object> value;

        ListAddOperation(List<? extends Object> obj) {
            this.value = obj;
        }

        @Override
        public Collection<ParsedBootOp> getOperations(ImmutableManagementResourceRegistration rootRegistration, PathAddress address, String name) {
            ArrayList<ParsedBootOp> operations = new ArrayList<ParsedBootOp>();
            OperationEntry operationEntry = rootRegistration.getOperationEntry(address, "list-add");
            if (operationEntry == null) {
                return Collections.emptyList();
            }
            AttributeAccess access = rootRegistration.getAttributeAccess(address, name);
            ListAttributeDefinition att = (ListAttributeDefinition)access.getAttributeDefinition();
            AttributeDefinition type = att.getValueAttributeDefinition();
            if (type == null) {
                throw ControllerLogger.ROOT_LOGGER.missingListAttributeValueType(att.getName());
            }
            String attributeName = att.getName();
            for (Object object : this.value) {
                ModelNode op = new ModelNode();
                op.get("address").set(address.toModelNode());
                op.get("name").set(attributeName);
                op.get("operation").set("list-add");
                switch (type.getType()) {
                    case OBJECT: {
                        Map map = (Map)object;
                        if (map.containsKey("index")) {
                            op.get("index").set(((Integer)map.get("index")).intValue());
                        }
                        op.get("value").set(YamlConfigurationExtension.this.processObjectAttribute((ObjectTypeAttributeDefinition)type, map));
                        break;
                    }
                    case LIST: {
                        if (object instanceof Map) {
                            Map indexedEntry = (Map)object;
                            if (indexedEntry.containsKey("index")) {
                                op.get("index").set(((Integer)indexedEntry.get("index")).intValue());
                                indexedEntry.remove("index");
                            }
                            for (Map.Entry realValue : indexedEntry.entrySet()) {
                                op.get("value").set(realValue.getValue().toString());
                            }
                            break;
                        }
                        op.get("value").set(object.toString());
                        break;
                    }
                    default: {
                        if (object instanceof Map) {
                            Map indexedSimpleType = (Map)object;
                            if (indexedSimpleType.size() == 1) {
                                String realValue = (String)indexedSimpleType.keySet().iterator().next();
                                Map indexedEntry = (Map)indexedSimpleType.get(realValue);
                                if (indexedEntry.containsKey("index")) {
                                    op.get("index").set(((Integer)indexedEntry.get("index")).intValue());
                                }
                                op.get("value").set(realValue);
                                break;
                            }
                            Map indexedEntry = (Map)object;
                            if (indexedEntry.containsKey("index")) {
                                op.get("index").set(((Integer)indexedEntry.get("index")).intValue());
                                indexedEntry.remove("index");
                            }
                            for (Map.Entry realValue : indexedEntry.entrySet()) {
                                op.get("value").set(realValue.getValue().toString());
                            }
                            break;
                        }
                        op.get("value").set(object.toString());
                    }
                }
                ParsedBootOp operation = new ParsedBootOp(op, operationEntry.getOperationHandler());
                ControllerLogger.MGMT_OP_LOGGER.debugf("Updating attribute %s for resource %s with operation %s", attributeName, address, op);
                operations.add(operation);
            }
            return operations;
        }
    }

    private class UndefineOperation
    implements Operation {
        UndefineOperation() {
        }

        @Override
        public Collection<ParsedBootOp> getOperations(ImmutableManagementResourceRegistration rootRegistration, PathAddress address, String name) {
            OperationEntry operationEntry = rootRegistration.getOperationEntry(address, "undefine-attribute");
            if (operationEntry == null) {
                return Collections.emptyList();
            }
            ModelNode op = new ModelNode();
            op.get("operation").set("undefine-attribute");
            op.get("address").set(address.toModelNode());
            op.get("name").set(name);
            return Collections.singletonList(new ParsedBootOp(op, operationEntry.getOperationHandler()));
        }
    }

    private class RemoveOperation
    implements Operation {
        RemoveOperation() {
        }

        @Override
        public Collection<ParsedBootOp> getOperations(ImmutableManagementResourceRegistration rootRegistration, PathAddress address, String name) {
            OperationEntry operationEntry = rootRegistration.getOperationEntry(address, "remove");
            if (operationEntry == null) {
                return Collections.emptyList();
            }
            ModelNode op = new ModelNode();
            op.get("operation").set("remove");
            op.get("address").set(address.toModelNode());
            return Collections.singletonList(new ParsedBootOp(op, operationEntry.getOperationHandler()));
        }
    }

    private static interface Operation {
        public Collection<ParsedBootOp> getOperations(ImmutableManagementResourceRegistration var1, PathAddress var2, String var3);
    }
}

