/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.List;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public final class ModuleClassPathProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List additionalModules;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        AttachmentList<ModuleIdentifier> entries = deploymentUnit.getAttachment(Attachments.CLASS_PATH_ENTRIES);
        if (entries != null) {
            for (ModuleIdentifier entry : entries) {
                moduleSpecification.addLocalDependency(new ModuleDependency(moduleLoader, entry, false, true, true, false));
            }
        }
        if ((additionalModules = (List)deploymentUnit.getAttachment(Attachments.ADDITIONAL_MODULES)) != null) {
            for (AdditionalModuleSpecification additionalModule : additionalModules) {
                AttachmentList<ModuleIdentifier> dependencies = additionalModule.getAttachment(Attachments.CLASS_PATH_ENTRIES);
                if (dependencies == null || dependencies.isEmpty()) continue;
                for (ModuleIdentifier entry : dependencies) {
                    additionalModule.addLocalDependency(new ModuleDependency(moduleLoader, entry, false, true, true, false));
                }
                additionalModule.addLocalDependency(new ModuleDependency(moduleLoader, deploymentUnit.getAttachment(Attachments.MODULE_IDENTIFIER), false, false, true, false));
            }
        }
    }
}

