/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.logmanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Handler;
import org.jboss.as.logging.logmanager.WildFlyLogContextSelectorImpl;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.logmanager.config.LogContextConfiguration;

public interface WildFlyLogContextSelector
extends LogContextSelector {
    public LogContext setLocalContext(LogContext var1);

    public void registerLogContext(ClassLoader var1, LogContext var2);

    public boolean unregisterLogContext(ClassLoader var1, LogContext var2);

    public boolean addLogApiClassLoader(ClassLoader var1);

    public boolean removeLogApiClassLoader(ClassLoader var1);

    public int registeredCount();

    public static class Factory {
        private static final LogContext EMBEDDED_LOG_CONTEXT = LogContext.create();

        public static WildFlyLogContextSelector create() {
            return new WildFlyLogContextSelectorImpl(LogContext.getLogContextSelector());
        }

        public static WildFlyLogContextSelector createEmbedded() {
            Factory.clearLogContext();
            return new WildFlyLogContextSelectorImpl(EMBEDDED_LOG_CONTEXT);
        }

        private static void clearLogContext() {
            Configurator configurator = (Configurator)EMBEDDED_LOG_CONTEXT.getLogger("").detach(Configurator.ATTACHMENT_KEY);
            if (configurator instanceof PropertyConfigurator) {
                LogContextConfiguration logContextConfiguration = ((PropertyConfigurator)configurator).getLogContextConfiguration();
                Factory.clearLogContext(logContextConfiguration);
            } else if (configurator instanceof LogContextConfiguration) {
                Factory.clearLogContext((LogContextConfiguration)configurator);
            } else {
                ArrayList<String> loggerNames = Collections.list(EMBEDDED_LOG_CONTEXT.getLoggerNames());
                for (String name : loggerNames) {
                    Logger logger2 = EMBEDDED_LOG_CONTEXT.getLoggerIfExists(name);
                    if (logger2 == null) continue;
                    Handler[] handlers = logger2.clearHandlers();
                    if (handlers != null) {
                        for (Handler handler : handlers) {
                            handler.close();
                        }
                    }
                    logger2.setFilter(null);
                    logger2.setUseParentFilters(false);
                    logger2.setUseParentHandlers(true);
                    logger2.setLevel((java.util.logging.Level)Level.INFO);
                }
            }
        }

        private static void clearLogContext(LogContextConfiguration logContextConfiguration) {
            try {
                for (String name : logContextConfiguration.getLoggerNames()) {
                    logContextConfiguration.removeLoggerConfiguration(name);
                }
                for (String name : logContextConfiguration.getHandlerNames()) {
                    logContextConfiguration.removeHandlerConfiguration(name);
                }
                for (String name : logContextConfiguration.getFormatterNames()) {
                    logContextConfiguration.removeFormatterConfiguration(name);
                }
                for (String name : logContextConfiguration.getErrorManagerNames()) {
                    logContextConfiguration.removeErrorManagerConfiguration(name);
                }
                for (String name : logContextConfiguration.getPojoNames()) {
                    logContextConfiguration.removePojoConfiguration(name);
                }
                for (String name : logContextConfiguration.getFilterNames()) {
                    logContextConfiguration.removeFilterConfiguration(name);
                }
                logContextConfiguration.commit();
            }
            finally {
                logContextConfiguration.forget();
            }
        }
    }
}

