/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.services.path;

import java.io.File;
import java.util.function.Consumer;
import org.jboss.as.controller.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.common.Assert;

public class AbsolutePathService
extends AbstractPathService {
    private final String absolutePath;

    private AbsolutePathService(Consumer<String> pathConsumer, String abstractPath) {
        super(pathConsumer);
        this.absolutePath = AbsolutePathService.convertPath(abstractPath);
    }

    public static ServiceController<?> addService(String name, String abstractPath, ServiceTarget serviceTarget) {
        return AbsolutePathService.addService(AbsolutePathService.pathNameOf(name), abstractPath, serviceTarget);
    }

    public static ServiceController<?> addService(ServiceName sname, String abstractPath, ServiceTarget serviceTarget) {
        ServiceBuilder builder = serviceTarget.addService(sname);
        Consumer pathConsumer = builder.provides(new ServiceName[]{sname});
        builder.setInstance((Service)new AbsolutePathService(pathConsumer, abstractPath));
        return builder.install();
    }

    public static void addService(ServiceName name, ModelNode element, ServiceTarget serviceTarget) {
        String path = element.require("path").asString();
        AbsolutePathService.addService(name, path, serviceTarget);
    }

    public static String convertPath(String abstractPath) {
        Assert.checkNotNullParam((String)"abstractPath", (Object)abstractPath);
        Assert.checkNotEmptyParam((String)"abstractPath", (String)abstractPath);
        File f = new File(abstractPath);
        return f.getAbsolutePath();
    }

    @Override
    protected String resolvePath() {
        return this.absolutePath;
    }
}

