/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.remoting.AbstractOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.as.remoting.LocalOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.LocalOutboundConnectionService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

class LocalOutboundConnectionAdd
extends AbstractAddStepHandler {
    static final LocalOutboundConnectionAdd INSTANCE = new LocalOutboundConnectionAdd();

    private LocalOutboundConnectionAdd() {
        super(new AttributeDefinition[]{LocalOutboundConnectionResourceDefinition.OUTBOUND_SOCKET_BINDING_REF});
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        this.installRuntimeService(context, resource.getModel());
    }

    void installRuntimeService(OperationContext context, ModelNode model) throws OperationFailedException {
        String connectionName = context.getCurrentAddressValue();
        String outboundSocketBindingRef = LocalOutboundConnectionResourceDefinition.OUTBOUND_SOCKET_BINDING_REF.resolveModelAttribute(context, model).asString();
        ServiceName outboundSocketBindingDependency = context.getCapabilityServiceName("org.wildfly.network.outbound-socket-binding", outboundSocketBindingRef, OutboundSocketBinding.class);
        ServiceName serviceName = AbstractOutboundConnectionResourceDefinition.OUTBOUND_CONNECTION_CAPABILITY.getCapabilityServiceName(new String[]{connectionName});
        ServiceName aliasServiceName = LocalOutboundConnectionService.LOCAL_OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionName});
        ServiceName deprecatedServiceName = AbstractOutboundConnectionService.OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionName});
        ServiceBuilder builder = context.getServiceTarget().addService(serviceName);
        Consumer serviceConsumer = builder.provides(new ServiceName[]{deprecatedServiceName, aliasServiceName});
        Supplier osbSupplier = builder.requires(outboundSocketBindingDependency);
        builder.requires(RemotingServices.SUBSYSTEM_ENDPOINT);
        builder.setInstance((Service)new LocalOutboundConnectionService(serviceConsumer, osbSupplier));
        builder.install();
    }
}

